/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.value;

import java.util.List;
import java.util.Map;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class ValueUtils {
    private static final String ERROR_MSG = "Unhandled value type: ";

    public static Value toEmptyValue(ValueType type, String time) {
        if (type.compare(ValueType.NUMBER)) {
            return new Value((Number)null, time);
        }
        if (type.compare(ValueType.BOOL)) {
            return new Value((Boolean)null, time);
        }
        if (type.compare(ValueType.STRING)) {
            return new Value((String)null, time);
        }
        if (type.compare(ValueType.MAP)) {
            return new Value((JsonObject)null, time);
        }
        if (type.compare(ValueType.ARRAY)) {
            return new Value((JsonArray)null, time);
        }
        if (type.compare(ValueType.BINARY)) {
            return new Value((byte[])null, time);
        }
        throw new RuntimeException(ERROR_MSG + type.getRawName());
    }

    public static Value toValue(Object object) {
        return ValueUtils.toValue(object, null);
    }

    public static Value toValue(Object object, String time) {
        Value val;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            val = new Value((Number)object, time);
        } else if (object instanceof Boolean) {
            val = new Value((Boolean)object, time);
        } else if (object instanceof String) {
            val = new Value((String)object, time);
        } else if (object instanceof JsonObject) {
            val = new Value((JsonObject)object, time);
        } else if (object instanceof Map) {
            val = new Value(new JsonObject((Map)object), time);
        } else if (object instanceof JsonArray) {
            val = new Value((JsonArray)object, time);
        } else if (object instanceof List) {
            val = new Value(new JsonArray((List)object), time);
        } else if (object instanceof byte[]) {
            val = new Value((byte[])object, time);
        } else {
            throw new RuntimeException(ERROR_MSG + object.getClass().getName());
        }
        return val;
    }

    public static Object toObject(Value value) {
        if (value == null) {
            return null;
        }
        switch (value.getType().toJsonString()) {
            case "bool": {
                return value.getBool();
            }
            case "number": {
                return value.getNumber();
            }
            case "string": {
                return value.getString();
            }
            case "map": {
                return value.getMap();
            }
            case "array": {
                return value.getArray();
            }
            case "binary": {
                return value.getBinary();
            }
        }
        throw new RuntimeException(ERROR_MSG + value.getType());
    }

    public static void checkType(String name, ValueType type, Value value) {
        ValueType vt = value.getType();
        if (!type.compare(ValueType.DYNAMIC) && type.compare(ValueType.ENUM) && !vt.compare(ValueType.STRING) && !type.compare(vt)) {
            String t = value.getType().toJsonString();
            String msg = "Parameter " + name + " has a bad type of " + t;
            msg = msg + " expected " + type.getRawName();
            throw new RuntimeException(msg);
        }
    }
}

