/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.provider.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.util.Map;
import javax.net.ssl.TrustManagerFactory;
import org.dsa.iot.dslink.provider.HttpProvider;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.http.HttpResp;
import org.dsa.iot.shared.SharedObjects;

public class DefaultHttpProvider
extends HttpProvider {
    @Override
    public HttpResp post(URLInfo url, byte[] content, Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        try {
            HttpHandler handler = new HttpHandler();
            Bootstrap b = new Bootstrap();
            b.group(SharedObjects.getLoop());
            b.channel(NioSocketChannel.class);
            b.handler((ChannelHandler)new Initializer(handler, url.secure));
            ChannelFuture fut = b.connect(url.host, url.port);
            Channel chan = fut.sync().channel();
            chan.writeAndFlush((Object)this.populateRequest(url.path, content, headers));
            fut.channel().closeFuture().sync();
            return this.populateResponse(handler);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private HttpRequest populateRequest(String uri, byte[] content, Map<String, String> headers) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri);
        ByteBuf buf = request.content();
        if (content != null) {
            buf.writeBytes(content);
        }
        HttpHeaders h = request.headers();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                h.set(name, (Object)value);
            }
        }
        String len = String.valueOf(buf.readableBytes());
        h.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)len);
        return request;
    }

    private HttpResp populateResponse(HttpHandler handler) throws Throwable {
        Throwable throwable = handler.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
        HttpResp resp = new HttpResp();
        resp.setStatus(handler.getStatus());
        resp.setBody(handler.getContent());
        return resp;
    }

    private static class HttpHandler
    extends SimpleChannelInboundHandler<Object> {
        private StringBuffer content = new StringBuffer();
        private HttpResponseStatus status;
        private Throwable t;

        private HttpHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpResponse) {
                HttpResponse resp = (HttpResponse)msg;
                this.status = resp.status();
            }
            if (msg instanceof HttpContent) {
                ByteBuf buf = ((HttpContent)msg).content();
                this.content.append(buf.toString(CharsetUtil.UTF_8));
            }
            if (msg instanceof LastHttpContent) {
                ctx.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
            this.t = t;
            ctx.close();
        }

        public Throwable getThrowable() {
            return this.t;
        }

        public HttpResponseStatus getStatus() {
            return this.status;
        }

        public String getContent() {
            return this.content.toString();
        }
    }

    private static class Initializer
    extends ChannelInitializer<SocketChannel> {
        private final HttpHandler handler;
        private final boolean secure;

        public Initializer(HttpHandler handler, boolean secure) {
            this.handler = handler;
            this.secure = secure;
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline p = ch.pipeline();
            if (this.secure) {
                TrustManagerFactory man = InsecureTrustManagerFactory.INSTANCE;
                SslContextBuilder scb = SslContextBuilder.forClient();
                SslContext con = scb.trustManager(man).build();
                p.addLast(new ChannelHandler[]{con.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpClientCodec()});
            p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            p.addLast(new ChannelHandler[]{this.handler});
        }
    }
}

