/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.provider.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.TrustManagerFactory;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.provider.WsProvider;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.http.WsClient;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.shared.SharedObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWsProvider
extends WsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWsProvider.class);

    @Override
    public void connect(WsClient client) {
        URI uri;
        if (client == null) {
            throw new NullPointerException("client");
        }
        final URLInfo url = client.getUrl();
        String full = url.protocol + "://" + url.host + ":" + url.port + url.path;
        full = full.replaceAll("%", "%25");
        try {
            uri = new URI(full);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        WebSocketVersion v = WebSocketVersion.V13;
        DefaultHttpHeaders h = new DefaultHttpHeaders();
        WebSocketClientHandshaker wsch = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)v, null, (boolean)true, (HttpHeaders)h, (int)Integer.MAX_VALUE);
        final WebSocketHandler handler = new WebSocketHandler(wsch, client);
        Bootstrap b = new Bootstrap();
        b.group(SharedObjects.getLoop());
        b.channel(NioSocketChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (url.secure) {
                    TrustManagerFactory man = InsecureTrustManagerFactory.INSTANCE;
                    SslContextBuilder scb = SslContextBuilder.forClient();
                    SslContext con = scb.trustManager(man).build();
                    p.addLast(new ChannelHandler[]{con.newHandler(ch.alloc())});
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                PerMessageDeflateClientExtensionHandshaker com = new PerMessageDeflateClientExtensionHandshaker();
                p.addLast(new ChannelHandler[]{new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{com})});
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        ChannelFuture fut = b.connect(url.host, url.port);
        fut.syncUninterruptibly();
        handler.handshakeFuture().syncUninterruptibly();
    }

    private static class WebSocketHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WsClient client;
        private WebSocketClientHandshaker handshake;
        private ChannelPromise handshakeFuture;

        public WebSocketHandler(WebSocketClientHandshaker handshake, WsClient client) {
            this.handshake = handshake;
            this.client = client;
        }

        public ChannelFuture handshakeFuture() {
            return this.handshakeFuture;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            this.handshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.handshake.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            this.client.onDisconnected();
        }

        public void channelRead0(final ChannelHandlerContext ctx, Object msg) {
            final Channel ch = ctx.channel();
            if (this.handshake != null && !this.handshake.isHandshakeComplete()) {
                this.handshake.finishHandshake(ch, (FullHttpResponse)msg);
                this.handshake = null;
                if (this.handshakeFuture != null) {
                    this.handshakeFuture.setSuccess();
                    this.handshakeFuture = null;
                }
                this.client.onConnected(new NetworkClient(){

                    @Override
                    public boolean writable() {
                        return ch.isWritable();
                    }

                    @Override
                    public void write(EncodingFormat format, JsonObject data) {
                        byte[] bytes = data.encode(format);
                        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
                        BinaryWebSocketFrame frame = null;
                        if (format == EncodingFormat.MESSAGE_PACK) {
                            frame = new BinaryWebSocketFrame(buf);
                        } else if (format == EncodingFormat.JSON) {
                            frame = new TextWebSocketFrame(buf);
                        } else {
                            String err = "Unsupported encoding format: {}";
                            LOGGER.error(err, (Object)format);
                        }
                        if (frame != null) {
                            ch.writeAndFlush((Object)frame);
                        }
                    }

                    @Override
                    public void close() {
                        ctx.close();
                    }

                    @Override
                    public boolean isConnected() {
                        return ch.isOpen();
                    }
                });
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame) {
                byte[] bytes;
                ByteBuf content = frame.content();
                int offset = 0;
                int length = content.readableBytes();
                if (content.hasArray()) {
                    offset = content.arrayOffset();
                    bytes = content.array();
                } else {
                    bytes = new byte[length];
                    content.readBytes(bytes);
                }
                this.client.onData(bytes, offset, length);
            } else if (frame instanceof PingWebSocketFrame) {
                ByteBuf buf = frame.content().retain();
                PongWebSocketFrame pong = new PongWebSocketFrame(buf);
                ctx.channel().writeAndFlush((Object)pong);
            } else if (frame instanceof CloseWebSocketFrame) {
                this.client.onDisconnected();
                ctx.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.client.onThrowable(cause);
            if (this.handshakeFuture != null) {
                this.handshakeFuture.setFailure(cause);
            }
            ctx.close();
        }
    }
}

