/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.serializer;

import java.util.Map;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Deserializer {
    private final NodeManager manager;

    public Deserializer(NodeManager manager) {
        this.manager = manager;
    }

    public void deserialize(JsonObject object) {
        for (Map.Entry<String, Object> entry : object) {
            String name = entry.getKey();
            Node node = this.manager.getNode(name, true).getNode();
            Object value = entry.getValue();
            JsonObject data = (JsonObject)value;
            this.deserializeNode(node, data);
        }
    }

    private void deserializeNode(Node node, JsonObject map) {
        String type = (String)map.get("$type");
        if (type != null) {
            ValueType t = ValueType.toValueType(type);
            node.setValueType(t);
        }
        for (Map.Entry<String, Object> entry : map) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null || "$type".equals(name)) continue;
            if ("$is".equals(name)) {
                node.setProfile((String)value);
                continue;
            }
            if ("$interface".equals(name)) {
                node.setInterfaces((String)value);
                continue;
            }
            if ("$name".equals(name)) {
                node.setDisplayName((String)value);
                continue;
            }
            if ("$writable".equals(name)) {
                node.setWritable(Writable.toEnum((String)value));
                continue;
            }
            if ("$hidden".equals(name)) {
                node.setHidden((Boolean)value);
                continue;
            }
            if ("$$password".equals(name)) {
                node.setPassword(((String)value).toCharArray());
                continue;
            }
            if ("?value".equals(name)) {
                node.setValue(ValueUtils.toValue(value));
                continue;
            }
            if (name.startsWith("$$")) {
                node.setRoConfig(name.substring(2), ValueUtils.toValue(value));
                continue;
            }
            if (name.startsWith("$")) {
                node.setConfig(name.substring(1), ValueUtils.toValue(value));
                continue;
            }
            if (name.startsWith("@")) {
                node.setAttribute(name.substring(1), ValueUtils.toValue(value));
                continue;
            }
            Node child = node.createChild(name).build();
            JsonObject children = (JsonObject)value;
            this.deserializeNode(child, children);
        }
    }
}

