/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.serializer;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.serializer.Deserializer;
import org.dsa.iot.dslink.serializer.Serializer;
import org.dsa.iot.dslink.util.FileUtils;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationManager.class);
    private final File file;
    private final File backup;
    private final Deserializer deserializer;
    private final Serializer serializer;
    private ScheduledFuture<?> future;
    private final AtomicBoolean changed = new AtomicBoolean(false);

    public SerializationManager(File file, NodeManager manager) {
        this.file = file;
        this.backup = new File(file.getPath() + ".bak");
        this.deserializer = new Deserializer(manager);
        this.serializer = new Serializer(manager);
    }

    public void markChanged() {
        this.changed.set(true);
    }

    public void markChangedOverride(boolean bool) {
        this.changed.set(bool);
    }

    public synchronized void start() {
        this.stop();
        ScheduledThreadPoolExecutor daemon = Objects.getDaemonThreadPool();
        this.future = daemon.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                boolean c = SerializationManager.this.changed.getAndSet(false);
                if (c) {
                    SerializationManager.this.serialize();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void serialize() {
        JsonObject json = this.serializer.serialize();
        try {
            if (this.file.exists()) {
                if (this.backup.exists() && !this.backup.delete()) {
                    LOGGER.error("Failed to remove backup data");
                }
                if (!this.file.renameTo(this.backup)) {
                    LOGGER.error("Failed to create backup data");
                }
                LOGGER.debug("Copying serialized data to a backup");
            }
            byte[] bytes = json.encodePrettily();
            FileUtils.write(this.file, bytes);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wrote serialized data: {}", (Object)json);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save serialized data", (Throwable)e);
        }
    }

    public void deserialize() throws Exception {
        this.deserialize(true);
    }

    private void deserialize(boolean cont) throws Exception {
        byte[] bytes = null;
        if (this.file.exists()) {
            try {
                bytes = FileUtils.readAllBytes(this.file);
            }
            catch (Exception ignored) {}
        } else if (this.backup.exists()) {
            bytes = FileUtils.readAllBytes(this.backup);
            FileUtils.write(this.file, bytes);
            LOGGER.warn("Restored backup data");
        }
        boolean tryAgain = false;
        if (bytes != null) {
            try {
                this.handle(bytes);
            }
            catch (Exception e) {
                if (!cont) {
                    throw e;
                }
                tryAgain = true;
            }
        } else {
            tryAgain = true;
        }
        if (tryAgain && cont) {
            if (!this.file.delete()) {
                LOGGER.debug("Failed to delete original file");
            }
            this.deserialize(false);
        }
    }

    private void handle(byte[] bytes) throws Exception {
        String in = new String(bytes, "UTF-8");
        JsonObject obj = new JsonObject(in);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read serialized data: " + obj);
        }
        this.deserializer.deserialize(obj);
    }
}

