/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.serializer;

import java.util.Map;
import java.util.Set;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.util.StringUtils;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Serializer {
    private final NodeManager manager;

    public Serializer(NodeManager manager) {
        this.manager = manager;
    }

    public JsonObject serialize() {
        JsonObject top = new JsonObject();
        Map<String, Node> rootChildren = this.manager.getChildren("/");
        if (rootChildren != null) {
            for (Node child : rootChildren.values()) {
                if (!child.isSerializable()) continue;
                JsonObject childOut = new JsonObject();
                this.serializeChildren(childOut, child);
                top.put(child.getName(), childOut);
            }
        }
        return top;
    }

    private void serializeChildren(JsonObject out, Node parent) {
        Writable writable;
        char[] password;
        ValueType type;
        String profile;
        Set<String> set;
        String data = parent.getDisplayName();
        if (data != null) {
            out.put("$name", data);
        }
        if ((set = parent.getInterfaces()) != null && set.size() > 0) {
            out.put("$interface", StringUtils.join(set, "|"));
        }
        if ((profile = parent.getProfile()) != null) {
            out.put("$is", profile);
        }
        if ((type = parent.getValueType()) != null) {
            out.put("$type", type.toJsonString());
            Value value = parent.getValue();
            if (value != null && value.isSerializable()) {
                out.put("?value", value);
            }
        }
        if ((password = parent.getPassword()) != null) {
            out.put("$$password", new String(password));
        }
        if ((writable = parent.getWritable()) != null && writable != Writable.NEVER) {
            out.put("$writable", writable.toJsonName());
        }
        if (parent.isHidden()) {
            out.put("$hidden", true);
        }
        this.addValues("$$", out, parent.getRoConfigurations());
        this.addValues("$", out, parent.getConfigurations());
        this.addValues("@", out, parent.getAttributes());
        Map<String, Node> children = parent.getChildren();
        if (children != null && children.size() > 0) {
            for (Node child : children.values()) {
                if (!child.isSerializable()) continue;
                JsonObject childOut = new JsonObject();
                this.serializeChildren(childOut, child);
                out.put(child.getName(), childOut);
            }
        }
    }

    private void addValues(String prefix, JsonObject out, Map<String, Value> vals) {
        if (vals == null || vals.size() == 0) {
            return;
        }
        for (Map.Entry<String, Value> entry : vals.entrySet()) {
            Value value = entry.getValue();
            if (!value.isSerializable()) continue;
            String name = prefix + entry.getKey();
            out.put(name, value);
        }
    }
}

