/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.SyncFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static byte[] readAllBytes(File src) throws IOException {
        try (FileInputStream stream = new FileInputStream(src);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int read = ((InputStream)stream).read(bytes);
            while (read != -1) {
                baos.write(bytes, 0, read);
                read = ((InputStream)stream).read(bytes);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void write(File path, byte[] bytes) throws IOException {
        if (path.delete() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removed " + path.getPath() + " during writing");
        }
        try (FileOutputStream stream = new FileOutputStream(path);){
            stream.write(bytes);
            stream.flush();
            try {
                stream.getFD().sync();
            }
            catch (SyncFailedException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        FileOutputStream output;
        block19: {
            if (dest.delete()) {
                LOGGER.debug("Removed " + dest.getPath() + " during copying");
            }
            FileInputStream input = null;
            output = null;
            try {
                int read;
                input = new FileInputStream(src);
                output = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((read = ((InputStream)input).read(buf)) > 0) {
                    output.write(buf, 0, read);
                }
                output.flush();
                try {
                    output.getFD().sync();
                }
                catch (SyncFailedException ignored) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                block22: {
                    StringWriter writer;
                    block21: {
                        try {
                            if (input != null) {
                                ((InputStream)input).close();
                            }
                        }
                        catch (IOException e) {
                            if (!LOGGER.isDebugEnabled()) break block21;
                            writer = new StringWriter();
                            e.printStackTrace(new PrintWriter(writer));
                            LOGGER.debug(writer.toString());
                        }
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) break block22;
                        writer = new StringWriter();
                        e.printStackTrace(new PrintWriter(writer));
                        LOGGER.debug(writer.toString());
                    }
                }
                throw throwable;
            }
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block19;
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                LOGGER.debug(writer.toString());
            }
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                LOGGER.debug(writer.toString());
            }
        }
    }
}

