/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util;

import java.util.Collection;
import org.dsa.iot.dslink.node.Node;

public class StringUtils {
    public static boolean isReference(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return name.startsWith("$") || name.startsWith("@");
    }

    public static String encodeName(String string) {
        return StringUtils.encodeName(string, Node.getBannedCharacters());
    }

    public static String encodeName(String string, char[] encode) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] nameChars = string.toCharArray();
        block0: for (int i = 0; i < nameChars.length; ++i) {
            char hexA;
            char nameChar = nameChars[i];
            if (nameChar == '%' && i + 1 < nameChars.length && ((hexA = nameChars[i + 1]) >= '0' && hexA <= '9' || hexA >= 'a' && hexA <= 'f' || hexA >= 'A' && hexA <= 'F') && i + 2 < nameChars.length) {
                char hexB = nameChars[i + 2];
                if (hexB >= '0' && hexB <= '9' || hexB >= 'a' && hexB <= 'f' || hexB >= 'A' && hexB <= 'F') {
                    i += 2;
                    builder.append(nameChar);
                    builder.append(hexA);
                    builder.append(hexB);
                    continue;
                }
                ++i;
                builder.append(nameChar);
                builder.append(hexA);
                continue;
            }
            for (char c : encode) {
                if (nameChar != c) continue;
                String re = Integer.toHexString(c);
                re = re.toUpperCase();
                builder.append('%');
                builder.append(re);
                continue block0;
            }
            builder.append(nameChar);
        }
        return builder.toString();
    }

    public static String decodeName(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] nameChars = string.toCharArray();
        for (int i = 0; i < nameChars.length; ++i) {
            char hexA;
            char nameChar = nameChars[i];
            if (nameChar == '%' && ((hexA = nameChars[i + 1]) >= '0' && hexA <= '9' || hexA >= 'a' && hexA <= 'f' || hexA >= 'A' && hexA <= 'F')) {
                char hexB;
                String s = String.valueOf(hexA);
                if (i + 2 < nameChars.length && ((hexB = nameChars[i + 2]) >= '0' && hexB <= '9' || hexB >= 'a' && hexB <= 'f' || hexB >= 'A' && hexB <= 'F')) {
                    ++i;
                    s = s + String.valueOf(hexB);
                }
                ++i;
                int c = Integer.parseInt(s, 16);
                builder.append((char)c);
                continue;
            }
            builder.append(nameChar);
        }
        return builder.toString();
    }

    public static String join(Collection<String> strings, String delimiter) {
        return StringUtils.join(strings, false, delimiter);
    }

    public static String join(Collection<String> strings, boolean encode, String delimiter) {
        if (strings == null) {
            throw new NullPointerException("strings");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        int size = strings.size();
        String[] array = strings.toArray(new String[size]);
        return StringUtils.join(array, encode, delimiter);
    }

    public static String join(String[] strings, String delimiter) {
        return StringUtils.join(strings, false, delimiter);
    }

    public static String join(String[] strings, boolean encode, String delimiter) {
        if (strings == null) {
            throw new NullPointerException("strings");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        if (strings.length <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = strings.length;
        int i = 0;
        while (true) {
            String s = strings[i];
            if (encode) {
                s = StringUtils.encodeName(s);
            }
            builder.append(s);
            if (++i >= size) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }
}

