/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util;

public class URLInfo {
    public final String protocol;
    public final String host;
    public final int port;
    public final String path;
    public final boolean secure;
    private boolean trustAllCertificates = true;

    public URLInfo(String protocol, String host, int port, String path, boolean secure) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.secure = secure;
    }

    public void setTrustAllCertificates(boolean trust) {
        this.trustAllCertificates = trust;
    }

    public boolean getTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public static URLInfo parse(String url) {
        return URLInfo.parse(url, null);
    }

    public static URLInfo parse(String url, Boolean secureOverride) {
        String[] parts = url.split("://");
        if (!url.contains("://") || parts.length > 2) {
            throw new RuntimeException("Invalid URL");
        }
        String protocol = parts[0];
        boolean secure = secureOverride != null ? secureOverride : URLInfo.getDefaultProtocolSecurity(protocol);
        String host = parts[1];
        String path = "/";
        int port = -1;
        if (host.contains(":")) {
            int index = host.indexOf(58);
            host = host.substring(0, index);
            String secondary = parts[1].substring(index + 1);
            if (secondary.contains("/")) {
                index = secondary.indexOf(47);
                port = Integer.parseInt(secondary.substring(0, index));
                path = secondary.substring(index);
            } else {
                port = Integer.parseInt(secondary);
            }
        } else if (host.contains("/")) {
            int index = host.indexOf(47);
            String tmp = host.substring(0, index);
            path = host.substring(index);
            host = tmp;
            if (path.isEmpty()) {
                path = "/";
            }
        }
        if (port == -1) {
            port = URLInfo.getDefaultPort(protocol);
        }
        return new URLInfo(protocol, host, port, path, secure);
    }

    public static boolean getDefaultProtocolSecurity(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        return "wss".equals(scheme) || "https".equals(scheme);
    }

    public static int getDefaultPort(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if ("ws".equals(scheme) || "http".equals(scheme)) {
            return 80;
        }
        if ("wss".equals(scheme) || "https".equals(scheme)) {
            return 443;
        }
        return -1;
    }
}

