/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util;

public class UrlBase64 {
    public static String encode(String data) {
        return UrlBase64.encode(data, "UTF-8");
    }

    public static String encode(String data, String encoding) {
        try {
            byte[] bytes = data.getBytes(encoding);
            return UrlBase64.encode(bytes, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(byte[] data) {
        return UrlBase64.encode(data, "UTF-8");
    }

    public static String encode(byte[] data, String encoding) {
        try {
            String s = new String(UrlBase64.bouncyEncode(data), encoding);
            return UrlBase64.stripPadding(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decode(String encoded) {
        return UrlBase64.decode(encoded, "UTF-8");
    }

    public static byte[] decode(String encoded, String encoding) {
        try {
            encoded = UrlBase64.addPadding(encoded);
            byte[] data = encoded.getBytes(encoding);
            return UrlBase64.bounceDecode(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeToString(String encoded) {
        return UrlBase64.decodeToString(encoded, "UTF-8");
    }

    public static String decodeToString(String encoded, String encoding) {
        try {
            byte[] data = UrlBase64.decode(encoded, encoding);
            return new String(data, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripPadding(String encoded) {
        while (encoded.endsWith(".")) {
            encoded = encoded.substring(0, encoded.length() - 1);
        }
        return encoded;
    }

    public static String addPadding(String encoded) {
        StringBuilder buffer = new StringBuilder(encoded);
        while (buffer.length() % 4 != 0) {
            buffer.append(".");
        }
        return buffer.toString();
    }

    private static byte[] bouncyEncode(byte[] data) {
        return org.bouncycastle.util.encoders.UrlBase64.encode((byte[])data);
    }

    private static byte[] bounceDecode(byte[] data) {
        return org.bouncycastle.util.encoders.UrlBase64.decode((byte[])data);
    }
}

