/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.http;

import java.util.HashMap;
import org.dsa.iot.dslink.provider.HttpProvider;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.http.HttpResp;

public class HttpClient {
    private final URLInfo url;

    public HttpClient(URLInfo url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.url = url;
    }

    public HttpResp post(String uri, byte[] content) {
        HttpProvider provider = HttpProvider.getProvider();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("connection", "close");
        headers.put("accept-encoding", "text/plain");
        headers.put("host", this.url.host);
        URLInfo tmp = HttpClient.createUrlFromUri(this.url, uri);
        return provider.post(tmp, content, headers);
    }

    private static URLInfo createUrlFromUri(URLInfo url, String uri) {
        if (uri == null || uri.isEmpty()) {
            uri = "/";
        }
        return new URLInfo(url.protocol, url.host, url.port, uri, url.secure);
    }
}

