/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json;

import org.dsa.iot.dslink.util.json.JsonArray;

public enum EncodingFormat {
    MESSAGE_PACK("msgpack"),
    JSON("json");

    private final String name;

    private EncodingFormat(String name) {
        this.name = name;
    }

    public String toJson() {
        return this.name;
    }

    public static JsonArray toJsonArray() {
        JsonArray array = new JsonArray();
        for (EncodingFormat format : EncodingFormat.values()) {
            array.add(format.toJson());
        }
        return array;
    }

    public static EncodingFormat toEnum(String format) {
        if (format == null) {
            return JSON;
        }
        if (EncodingFormat.MESSAGE_PACK.name.equals(format = format.toLowerCase())) {
            return MESSAGE_PACK;
        }
        if (EncodingFormat.JSON.name.equals(format)) {
            return JSON;
        }
        return JSON;
    }
}

