/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.UrlBase64;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.json.decoders.ListDecoder;
import org.dsa.iot.dslink.util.json.decoders.MapDecoder;
import org.dsa.iot.dslink.util.json.encoders.ListEncoder;
import org.dsa.iot.dslink.util.json.encoders.MapEncoder;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Json {
    private static final MessagePackFactory MSG_FACTORY = new MessagePackFactory();
    private static final JsonFactory JSON_FACTORY = new JsonFactory(){

        protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
            SerializableString rootSep;
            UTF8JsonGenerator gen = new UTF8JsonGenerator(ctxt, this._generatorFeatures, this._objectCodec, out){

                public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
                    String s = "\u001bbytes:" + UrlBase64.encode(data);
                    this.writeString(s);
                }
            };
            if (this._characterEscapes != null) {
                gen.setCharacterEscapes(this._characterEscapes);
            }
            if ((rootSep = this._rootValueSeparator) != DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR) {
                gen.setRootValueSeparator(rootSep);
            }
            return gen;
        }
    };

    private Json() {
    }

    public static byte[] encode(EncodingFormat format, Object obj) {
        return Json.performEncode(format, obj, null);
    }

    public static byte[] encodePrettily(EncodingFormat format, Object obj) {
        return Json.performEncode(format, obj, (PrettyPrinter)new DefaultPrettyPrinter());
    }

    private static byte[] performEncode(EncodingFormat format, Object obj, PrettyPrinter printer) {
        JsonGenerator gen;
        ByteArrayOutputStream baos;
        block9: {
            baos = new ByteArrayOutputStream();
            JsonEncoding enc = JsonEncoding.UTF8;
            try {
                if (format == EncodingFormat.JSON) {
                    gen = JSON_FACTORY.createGenerator((OutputStream)baos, enc);
                    break block9;
                }
                if (format == EncodingFormat.MESSAGE_PACK) {
                    gen = MSG_FACTORY.createGenerator((OutputStream)baos, enc);
                    break block9;
                }
                throw new UnsupportedOperationException(format.toJson());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            gen.setPrettyPrinter(printer);
            if (obj instanceof JsonObject) {
                MapEncoder.write(gen, (JsonObject)obj);
            } else if (obj instanceof JsonArray) {
                ListEncoder.write(gen, (JsonArray)obj);
            }
            gen.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> decodeMap(EncodingFormat format, byte[] content, int offset, int length) {
        if (format == EncodingFormat.JSON) {
            return MapDecoder.decode(JSON_FACTORY, content, offset, length);
        }
        if (format == EncodingFormat.MESSAGE_PACK) {
            return MapDecoder.decode((JsonFactory)MSG_FACTORY, content, offset, length);
        }
        throw new UnsupportedOperationException(format.toJson());
    }

    public static List<Object> decodeList(EncodingFormat format, byte[] content, int offset, int length) {
        if (format == EncodingFormat.JSON) {
            return ListDecoder.decode(JSON_FACTORY, content, offset, length);
        }
        if (format == EncodingFormat.MESSAGE_PACK) {
            return ListDecoder.decode((JsonFactory)MSG_FACTORY, content, offset, length);
        }
        throw new UnsupportedOperationException(format.toJson());
    }

    public static Object checkAndUpdate(Object value) {
        if (!(value == null || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof String || value instanceof Map || value instanceof List || value instanceof JsonObject || value instanceof JsonArray || value instanceof Value || value instanceof byte[])) {
            throw new IllegalArgumentException("Invalid class: " + value.getClass());
        }
        if (value instanceof Map) {
            return new JsonObject((Map)value);
        }
        if (value instanceof List) {
            return new JsonArray((List)value);
        }
        if (value instanceof Value) {
            return ValueUtils.toObject((Value)value);
        }
        return value;
    }

    public static Object update(Object value) {
        if (value instanceof Map) {
            return new JsonObject((Map)value);
        }
        if (value instanceof List) {
            return new JsonArray((List)value);
        }
        return value;
    }
}

