/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json;

import io.netty.util.CharsetUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.Json;

public class JsonArray
implements Iterable<Object> {
    private final List<Object> list;

    public JsonArray() {
        this(new LinkedList());
    }

    public JsonArray(String content) {
        this(EncodingFormat.JSON, content.getBytes(CharsetUtil.UTF_8));
    }

    public JsonArray(EncodingFormat format, byte[] content) {
        this(format, content, 0, content.length);
    }

    public JsonArray(EncodingFormat format, byte[] content, int offset, int length) {
        this(Json.decodeList(format, content, offset, length));
    }

    public JsonArray(List list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        this.list = list;
    }

    public byte[] encode() {
        return this.encode(EncodingFormat.JSON);
    }

    public byte[] encode(EncodingFormat format) {
        return Json.encode(format, this);
    }

    public byte[] encodePrettily() {
        return this.encodePrettily(EncodingFormat.JSON);
    }

    public byte[] encodePrettily(EncodingFormat format) {
        return Json.encodePrettily(format, this);
    }

    public <T> T remove(int index) {
        return (T)Json.update(this.list.remove(index));
    }

    public <T> T get(int index) {
        return (T)Json.update(this.list.get(index));
    }

    public <T> T set(int index, Object value) {
        value = Json.checkAndUpdate(value);
        return (T)this.list.set(index, value);
    }

    public JsonArray add(Object value) {
        value = Json.checkAndUpdate(value);
        this.list.add(value);
        return this;
    }

    public JsonArray add(int pos, Object value) {
        value = Json.checkAndUpdate(value);
        this.list.add(pos, value);
        return this;
    }

    public JsonArray addAll(int pos, List<Object> values) {
        if (values != null) {
            ListIterator<Object> it = values.listIterator();
            while (it.hasNext()) {
                Object o = it.next();
                it.set(Json.checkAndUpdate(o));
            }
            this.list.addAll(pos, values);
        }
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public void mergeIn(JsonArray other) {
        this.list.addAll(other.list);
    }

    public List<Object> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public String toString() {
        return new String(this.encode(EncodingFormat.JSON), CharsetUtil.UTF_8);
    }

    @Override
    public Iterator<Object> iterator() {
        return new JsonIterator(this.list.iterator());
    }

    private static class JsonIterator
    implements Iterator<Object> {
        private final Iterator<Object> it;

        public JsonIterator(Iterator<Object> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            return Json.update(this.it.next());
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

