/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json;

import io.netty.util.CharsetUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.Json;
import org.dsa.iot.dslink.util.json.JsonArray;

public class JsonObject
implements Iterable<Map.Entry<String, Object>> {
    private final Map<String, Object> map;

    public JsonObject() {
        this(new LinkedHashMap<String, Object>());
    }

    public JsonObject(String json) {
        this(EncodingFormat.JSON, json.getBytes(CharsetUtil.UTF_8));
    }

    public JsonObject(EncodingFormat format, byte[] json) {
        this(format, json, 0, json.length);
    }

    public JsonObject(EncodingFormat format, byte[] json, int offset, int length) {
        this(Json.decodeMap(format, json, offset, length));
    }

    public JsonObject(Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this.map = map;
    }

    public byte[] encode() {
        return this.encode(EncodingFormat.JSON);
    }

    public byte[] encode(EncodingFormat format) {
        return Json.encode(format, this);
    }

    public byte[] encodePrettily() {
        return this.encodePrettily(EncodingFormat.JSON);
    }

    public byte[] encodePrettily(EncodingFormat format) {
        return Json.encodePrettily(format, this);
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public <T> T remove(String key) {
        return (T)Json.update(this.map.remove(key));
    }

    public <T> T get(String key) {
        return this.get(key, null);
    }

    public <T> T get(String key, T def) {
        Object t = Json.update(this.map.get(key));
        return (T)(t != null ? t : def);
    }

    public JsonObject put(String key, Object value) {
        Objects.requireNonNull(key);
        value = Json.checkAndUpdate(value);
        this.map.put(key, value);
        return this;
    }

    public int size() {
        return this.map.size();
    }

    public void mergeIn(JsonObject other) {
        this.mergeIn(other, false);
    }

    public void mergeIn(JsonObject other, boolean deep) {
        if (deep) {
            for (Map.Entry<String, Object> entry : other.map.entrySet()) {
                Object thisInst;
                String name = entry.getKey();
                Object instance = entry.getValue();
                if (instance instanceof JsonArray) {
                    thisInst = this.map.get(name);
                    if (!(thisInst instanceof JsonArray)) continue;
                    ((JsonArray)thisInst).mergeIn((JsonArray)instance);
                    continue;
                }
                if (instance instanceof JsonObject) {
                    thisInst = this.map.get(name);
                    if (!(thisInst instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)thisInst;
                    jsonObject.mergeIn((JsonObject)instance, true);
                    continue;
                }
                this.map.put(name, instance);
            }
            return;
        }
        this.map.putAll(other.map);
    }

    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public String toString() {
        return new String(this.encode(EncodingFormat.JSON), CharsetUtil.UTF_8);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new JsonIterator(this.map.entrySet().iterator());
    }

    private static class JsonIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<String, Object>> it;

        public JsonIterator(Iterator<Map.Entry<String, Object>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> entry = this.it.next();
            entry.setValue(Json.update(entry.getValue()));
            return entry;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

