/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json.decoders;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.json.decoders.MapDecoder;

public class ListDecoder {
    public static List<Object> decode(JsonFactory factory, byte[] content, int offset, int length) {
        LinkedList<Object> list = new LinkedList<Object>();
        JsonParser parser = null;
        try {
            parser = factory.createParser(content, offset, length);
            parser.nextToken();
            ListDecoder.performDecodeList(list, parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException ignored) {}
            }
        }
        return list;
    }

    static void performDecodeList(List<Object> in, JsonParser parser) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != JsonToken.END_ARRAY && token != null) {
            if (token == JsonToken.VALUE_NULL) {
                in.add(null);
                continue;
            }
            if (token == JsonToken.VALUE_STRING) {
                in.add(parser.getText());
                continue;
            }
            if (token == JsonToken.VALUE_FALSE) {
                in.add(false);
                continue;
            }
            if (token == JsonToken.VALUE_TRUE) {
                in.add(true);
                continue;
            }
            if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                in.add(parser.getNumberValue());
                continue;
            }
            if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
                in.add(parser.getBinaryValue());
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                LinkedList<Object> list = new LinkedList<Object>();
                ListDecoder.performDecodeList(list, parser);
                in.add(new JsonArray(list));
                continue;
            }
            if (token != JsonToken.START_OBJECT) continue;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            MapDecoder.performDecodeMap(map, parser);
            in.add(new JsonObject(map));
        }
    }
}

