/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json.decoders;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.json.decoders.ListDecoder;

public class MapDecoder {
    public static Map<String, Object> decode(JsonFactory factory, byte[] content, int offset, int length) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        JsonParser parser = null;
        try {
            parser = factory.createParser(content, offset, length);
            parser.nextToken();
            MapDecoder.performDecodeMap(map, parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException ignored) {}
            }
        }
        return map;
    }

    static void performDecodeMap(Map<String, Object> in, JsonParser parser) throws IOException {
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            String name = parser.getText();
            JsonToken token = parser.nextToken();
            if (token == null) break;
            if (token == JsonToken.VALUE_NULL) {
                in.put(name, null);
                continue;
            }
            if (token == JsonToken.VALUE_STRING) {
                in.put(name, parser.getText());
                continue;
            }
            if (token == JsonToken.VALUE_FALSE) {
                in.put(name, false);
                continue;
            }
            if (token == JsonToken.VALUE_TRUE) {
                in.put(name, true);
                continue;
            }
            if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                in.put(name, parser.getNumberValue());
                continue;
            }
            if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
                in.put(name, parser.getBinaryValue());
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                LinkedList<Object> list = new LinkedList<Object>();
                ListDecoder.performDecodeList(list, parser);
                in.put(name, new JsonArray(list));
                continue;
            }
            if (token != JsonToken.START_OBJECT) continue;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            MapDecoder.performDecodeMap(map, parser);
            in.put(name, new JsonObject(map));
        }
    }
}

