/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json.encoders;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.json.encoders.MapEncoder;

public class ListEncoder {
    public static void write(JsonGenerator gen, JsonArray json) throws IOException {
        gen.writeStartArray();
        ListEncoder.performWrite(gen, json);
    }

    static void performWrite(JsonGenerator gen, JsonArray json) throws IOException {
        for (Object instance : json) {
            if (instance instanceof Byte) {
                gen.writeNumber((short)((Number)instance).byteValue());
                continue;
            }
            if (instance instanceof Short) {
                gen.writeNumber(((Number)instance).shortValue());
                continue;
            }
            if (instance instanceof Integer) {
                gen.writeNumber(((Number)instance).intValue());
                continue;
            }
            if (instance instanceof Long) {
                gen.writeNumber(((Number)instance).longValue());
                continue;
            }
            if (instance instanceof Float) {
                gen.writeNumber(((Number)instance).floatValue());
                continue;
            }
            if (instance instanceof Double) {
                gen.writeNumber(((Number)instance).doubleValue());
                continue;
            }
            if (instance instanceof Boolean) {
                gen.writeBoolean(((Boolean)instance).booleanValue());
                continue;
            }
            if (instance instanceof String) {
                gen.writeString((String)instance);
                continue;
            }
            if (instance instanceof JsonObject) {
                gen.writeStartObject();
                MapEncoder.performWrite(gen, (JsonObject)instance);
                continue;
            }
            if (instance instanceof JsonArray) {
                gen.writeStartArray();
                ListEncoder.performWrite(gen, (JsonArray)instance);
                continue;
            }
            if (instance instanceof byte[]) {
                gen.writeBinary((byte[])instance);
                continue;
            }
            if (instance == null) {
                gen.writeNull();
                continue;
            }
            String err = "Unsupported class: " + instance.getClass().getName();
            throw new RuntimeException(err);
        }
        gen.writeEndArray();
    }
}

