/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.json.encoders;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.json.encoders.ListEncoder;

public class MapEncoder {
    public static void write(JsonGenerator gen, JsonObject json) throws IOException {
        gen.writeStartObject();
        MapEncoder.performWrite(gen, json);
    }

    static void performWrite(JsonGenerator gen, JsonObject json) throws IOException {
        for (Map.Entry<String, Object> entry : json) {
            String name = entry.getKey();
            Object instance = entry.getValue();
            if (instance instanceof Byte) {
                gen.writeNumberField(name, (int)((Number)instance).byteValue());
                continue;
            }
            if (instance instanceof Short) {
                gen.writeNumberField(name, (int)((Number)instance).shortValue());
                continue;
            }
            if (instance instanceof Integer) {
                gen.writeNumberField(name, ((Number)instance).intValue());
                continue;
            }
            if (instance instanceof Long) {
                gen.writeNumberField(name, ((Number)instance).longValue());
                continue;
            }
            if (instance instanceof Float) {
                gen.writeNumberField(name, ((Number)instance).floatValue());
                continue;
            }
            if (instance instanceof Double) {
                gen.writeNumberField(name, ((Number)instance).doubleValue());
                continue;
            }
            if (instance instanceof Boolean) {
                gen.writeBooleanField(name, ((Boolean)instance).booleanValue());
                continue;
            }
            if (instance instanceof String) {
                gen.writeStringField(name, (String)instance);
                continue;
            }
            if (instance instanceof JsonObject) {
                gen.writeObjectFieldStart(name);
                MapEncoder.performWrite(gen, (JsonObject)instance);
                continue;
            }
            if (instance instanceof JsonArray) {
                gen.writeArrayFieldStart(name);
                ListEncoder.performWrite(gen, (JsonArray)instance);
                continue;
            }
            if (instance instanceof byte[]) {
                gen.writeBinaryField(name, (byte[])instance);
                continue;
            }
            if (instance == null) {
                gen.writeNullField(name);
                continue;
            }
            String err = "Unsupported class: " + instance.getClass().getName();
            throw new RuntimeException(err);
        }
        gen.writeEndObject();
    }
}

