/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.util.log;

import java.io.File;
import org.dsa.iot.dslink.util.log.LogBridge;
import org.dsa.iot.dslink.util.log.LogLevel;
import org.dsa.iot.dslink.util.log.LoggingBridge;

public class LogManager {
    private static volatile LogBridge instance;

    public static void setBridge(LogBridge logBridge) {
        if (logBridge == null) {
            throw new NullPointerException("logBridge");
        }
        instance = logBridge;
    }

    private static LogBridge getBridge() {
        if (instance == null) {
            LogManager.setBridge(new LoggingBridge());
        }
        return instance;
    }

    public static void setLevel(String level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        switch (level = level.toLowerCase()) {
            case "none": 
            case "off": {
                LogManager.setLevel(LogLevel.OFF);
                break;
            }
            case "error": {
                LogManager.setLevel(LogLevel.ERROR);
                break;
            }
            case "warn": {
                LogManager.setLevel(LogLevel.WARN);
                break;
            }
            case "info": {
                LogManager.setLevel(LogLevel.INFO);
                break;
            }
            case "debug": {
                LogManager.setLevel(LogLevel.DEBUG);
                break;
            }
            case "trace": {
                LogManager.setLevel(LogLevel.TRACE);
                break;
            }
            default: {
                throw new RuntimeException("Unknown log level: " + level);
            }
        }
    }

    public static void setLevel(LogLevel level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        LogManager.getBridge().setLevel(level);
    }

    public static void configure(File logPath) {
        LogManager.getBridge().configure(logPath);
    }

    public static LogLevel getLevel() {
        return LogManager.getBridge().getLevel();
    }

    protected LogManager() {
    }
}

