/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.Level;
import org.slf4j.impl.LoggerImpl;

public class LoggerFactoryImpl
implements ILoggerFactory {
    private Level logLevel = Level.INFO;
    private PrintStream stream = System.out;
    private boolean shouldClose = false;

    public LoggerFactoryImpl() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!LoggerFactoryImpl.this.shouldClose) {
                    return;
                }
                LoggerFactoryImpl.this.stream.close();
            }
        }));
    }

    public void setLogPath(File logPath) {
        if (logPath == null) {
            this.shouldClose = false;
            this.stream = System.out;
            return;
        }
        try {
            if (this.shouldClose) {
                this.stream.close();
            }
            this.shouldClose = true;
            boolean exists = logPath.exists();
            FileOutputStream out = new FileOutputStream(logPath, exists);
            this.stream = new PrintStream((OutputStream)out, false, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public Logger getLogger(String name) {
        return new LoggerImpl(this, name);
    }
}

