/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.impl.Level;
import org.slf4j.impl.LoggerFactoryImpl;

public class LoggerImpl
implements Logger {
    private static final Pattern PATTERN = Pattern.compile("\\{\\}");
    private static final Object LOCK = new Object();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final LoggerFactoryImpl factory;
    private final String name;

    public LoggerImpl(LoggerFactoryImpl factory, String name) {
        this.factory = factory;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.factory.getLogLevel().getLevel() >= Level.TRACE.getLevel();
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg, null, null);
    }

    public void trace(String format, Object arg) {
        this.log(Level.TRACE, format, new Object[]{arg}, null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, new Object[]{arg1, arg2}, null);
    }

    public void trace(String format, Object ... argArray) {
        this.log(Level.TRACE, format, argArray, null);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.TRACE, msg, null, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.trace((String)null, (Object)msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace((String)null, (Object)format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace((String)null, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        this.trace((String)null, (Object)format, (Object)argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace((String)null, (Object)msg, (Object)t);
    }

    public boolean isDebugEnabled() {
        return this.factory.getLogLevel().getLevel() >= Level.DEBUG.getLevel();
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg, null, null);
    }

    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, new Object[]{arg}, null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, new Object[]{arg1, arg2}, null);
    }

    public void debug(String format, Object ... argArray) {
        this.log(Level.DEBUG, format, argArray, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.DEBUG, msg, null, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.debug((String)null, (Object)msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug((String)null, (Object)format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug((String)null, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        this.debug((String)null, (Object)format, (Object)argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug((String)null, (Object)msg, (Object)t);
    }

    public boolean isInfoEnabled() {
        return this.factory.getLogLevel().getLevel() >= Level.INFO.getLevel();
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null, null);
    }

    public void info(String format, Object arg) {
        this.log(Level.INFO, format, new Object[]{arg}, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, new Object[]{arg1, arg2}, null);
    }

    public void info(String format, Object ... argArray) {
        this.log(Level.INFO, format, argArray, null);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, null, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info((String)null, (Object)msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info((String)null, (Object)format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info((String)null, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.info((String)null, (Object)format, (Object)argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info((String)null, (Object)msg, (Object)t);
    }

    public boolean isWarnEnabled() {
        return this.factory.getLogLevel().getLevel() >= Level.WARN.getLevel();
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg, null, null);
    }

    public void warn(String format, Object arg) {
        this.log(Level.WARN, format, new Object[]{arg}, null);
    }

    public void warn(String format, Object ... argArray) {
        this.log(Level.WARN, format, argArray, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, new Object[]{arg1, arg2}, null);
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARN, msg, null, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn((String)null, (Object)msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn((String)null, (Object)format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn((String)null, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.warn((String)null, (Object)format, (Object)argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn((String)null, (Object)msg, (Object)t);
    }

    public boolean isErrorEnabled() {
        return this.factory.getLogLevel().getLevel() >= Level.ERROR.getLevel();
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg, null, null);
    }

    public void error(String format, Object arg) {
        this.log(Level.ERROR, format, new Object[]{arg}, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, new Object[]{arg1, arg2}, null);
    }

    public void error(String format, Object ... argArray) {
        this.log(Level.ERROR, format, argArray, null);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.ERROR, msg, null, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error((String)null, (Object)msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error((String)null, (Object)format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error((String)null, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.error((String)null, (Object)format, (Object)argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error((String)null, (Object)msg, (Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Level level, String msg, Object[] args, Throwable t) {
        if (this.factory.getLogLevel().getLevel() < level.getLevel()) {
            return;
        }
        if (msg != null && args != null) {
            Matcher matcher = PATTERN.matcher(msg);
            StringBuffer sb = new StringBuffer();
            for (int index = 0; matcher.find() && args.length > index; ++index) {
                String string;
                Object obj = args[index];
                if (obj instanceof String) {
                    string = (String)obj;
                } else if (obj instanceof Throwable) {
                    StringWriter writer = new StringWriter();
                    ((Throwable)obj).printStackTrace(new PrintWriter(writer));
                    string = writer.toString();
                } else {
                    string = obj != null ? obj.toString() : "null";
                }
                string = Matcher.quoteReplacement(string);
                matcher.appendReplacement(sb, string);
            }
            matcher.appendTail(sb);
            msg = sb.toString();
        }
        if (t != null) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            msg = msg + "\n" + writer.toString();
        }
        Date date = new Date();
        Object object = LOCK;
        synchronized (object) {
            String formatted = SDF.format(date);
            formatted = formatted + " [" + Thread.currentThread().getName() + "] " + level.getName() + " " + this.getName() + " - " + msg;
            this.factory.getPrintStream().println(formatted);
        }
    }
}

