/*
 * Decompiled with CFR 0.152.
 */
package org.iota.types;

import com.google.gson.JsonObject;
import org.iota.types.JsonUtils;

public class ClientConfig {
    private String primaryNode;
    private String primaryPowNode;
    private String[] nodes;
    private String[] permanodes;
    private Boolean ignoreNodeHealth;
    private NodeSyncInterval nodeSyncInterval;
    private Boolean quorum;
    private Integer minQuorumSize;
    private Integer quorumThreshold;
    private String network;
    private String networkId;
    private String bech32Hrp;
    private Integer minPowScore;
    private Boolean localPow;
    private Boolean fallbackToLocalPow;
    private Integer tipsInterval;
    private RentStructure rentStructure;
    private ApiTimeout apiTimeout;
    private RemotePowTimeout remotePowTimeout;
    private Integer powWorkerCount;

    public String getPrimaryNode() {
        return this.primaryNode;
    }

    public ClientConfig withPrimaryNode(String primaryNode) {
        this.primaryNode = primaryNode;
        return this;
    }

    public String getPrimaryPowNode() {
        return this.primaryPowNode;
    }

    public ClientConfig withPrimaryPowNode(String primaryPowNode) {
        this.primaryPowNode = primaryPowNode;
        return this;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public ClientConfig withNodes(String[] nodes) {
        this.nodes = nodes;
        return this;
    }

    public String[] getPermanodes() {
        return this.permanodes;
    }

    public ClientConfig withPermanodes(String[] permanodes) {
        this.permanodes = permanodes;
        return this;
    }

    public boolean isIgnoreNodeHealth() {
        return this.ignoreNodeHealth;
    }

    public ClientConfig withIgnoreNodeHealth(boolean ignoreNodeHealth) {
        this.ignoreNodeHealth = ignoreNodeHealth;
        return this;
    }

    public NodeSyncInterval getNodeSyncInterval() {
        return this.nodeSyncInterval;
    }

    public ClientConfig withNodeSyncInterval(NodeSyncInterval nodeSyncInterval) {
        this.nodeSyncInterval = nodeSyncInterval;
        return this;
    }

    public boolean isQuorum() {
        return this.quorum;
    }

    public ClientConfig withQuorum(boolean quorum) {
        this.quorum = quorum;
        return this;
    }

    public int getMinQuorumSize() {
        return this.minQuorumSize;
    }

    public ClientConfig withMinQuorumSize(int minQuorumSize) {
        this.minQuorumSize = minQuorumSize;
        return this;
    }

    public int getQuorumThreshold() {
        return this.quorumThreshold;
    }

    public ClientConfig withQuorumThreshold(int quorumThreshold) {
        this.quorumThreshold = quorumThreshold;
        return this;
    }

    public String getNetwork() {
        return this.network;
    }

    public ClientConfig withNetwork(String network) {
        this.network = network;
        return this;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public ClientConfig withNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    public String getBech32Hrp() {
        return this.bech32Hrp;
    }

    public ClientConfig withBech32Hrp(String bech32Hrp) {
        this.bech32Hrp = bech32Hrp;
        return this;
    }

    public int getMinPowScore() {
        return this.minPowScore;
    }

    public ClientConfig withMinPowScore(int minPowScore) {
        this.minPowScore = minPowScore;
        return this;
    }

    public boolean isLocalPow() {
        return this.localPow;
    }

    public ClientConfig withLocalPow(boolean localPow) {
        this.localPow = localPow;
        return this;
    }

    public boolean isFallbackToLocalPow() {
        return this.fallbackToLocalPow;
    }

    public ClientConfig withFallbackToLocalPow(boolean fallbackToLocalPow) {
        this.fallbackToLocalPow = fallbackToLocalPow;
        return this;
    }

    public int getTipsInterval() {
        return this.tipsInterval;
    }

    public ClientConfig withTipsInterval(int tipsInterval) {
        this.tipsInterval = tipsInterval;
        return this;
    }

    public RentStructure getRentStructure() {
        return this.rentStructure;
    }

    public ClientConfig withRentStructure(RentStructure rentStructure) {
        this.rentStructure = rentStructure;
        return this;
    }

    public Integer getPowWorkerCount() {
        return this.powWorkerCount;
    }

    public ClientConfig withPowWorkerCount(Integer powWorkerCount) {
        this.powWorkerCount = powWorkerCount;
        return this;
    }

    public JsonObject getJson() {
        JsonObject o = new JsonObject();
        if (this.primaryNode != null) {
            o.addProperty("primaryNode", this.primaryNode);
        }
        if (this.primaryPowNode != null) {
            o.addProperty("primaryPowNode", this.primaryPowNode);
        }
        if (this.nodes != null) {
            o.add("nodes", JsonUtils.toJson(this.nodes));
        }
        if (this.permanodes != null) {
            o.add("permanodes", JsonUtils.toJson(this.permanodes));
        }
        if (this.ignoreNodeHealth != null) {
            o.addProperty("ignoreNodeHealth", this.ignoreNodeHealth);
        }
        if (this.nodeSyncInterval != null) {
            o.add("nodeSyncInterval", this.nodeSyncInterval.getJson());
        }
        if (this.quorum != null) {
            o.addProperty("quorum", this.quorum);
        }
        if (this.minQuorumSize != null) {
            o.addProperty("minQuorumSize", this.minQuorumSize);
        }
        if (this.quorumThreshold != null) {
            o.addProperty("quorumThreshold", this.quorumThreshold);
        }
        if (this.network != null) {
            o.addProperty("network", this.network);
        }
        if (this.networkId != null) {
            o.addProperty("networkId", this.networkId);
        }
        if (this.bech32Hrp != null) {
            o.addProperty("bech32Hrp", this.bech32Hrp);
        }
        if (this.minPowScore != null) {
            o.addProperty("minPowScore", this.minPowScore);
        }
        if (this.localPow != null) {
            o.addProperty("localPow", this.localPow);
        }
        if (this.fallbackToLocalPow != null) {
            o.addProperty("fallbackToLocalPow", this.fallbackToLocalPow);
        }
        if (this.tipsInterval != null) {
            o.addProperty("tipsInterval", this.tipsInterval);
        }
        if (this.rentStructure != null) {
            o.add("rentStructure", this.rentStructure.getJson());
        }
        if (this.apiTimeout != null) {
            o.add("apiTimeout", this.apiTimeout.getJson());
        }
        if (this.powWorkerCount != null) {
            o.addProperty("powWorkerCount", this.powWorkerCount);
        }
        return o;
    }

    static class RemotePowTimeout {
        private int secs;
        private int nanos;

        RemotePowTimeout() {
        }

        public RemotePowTimeout withSecs(int secs) {
            this.secs = secs;
            return this;
        }

        public RemotePowTimeout withNanos(int nanos) {
            this.nanos = nanos;
            return this;
        }

        public JsonObject getJson() {
            JsonObject o = new JsonObject();
            o.addProperty("secs", this.secs);
            o.addProperty("nanos", this.nanos);
            return o;
        }
    }

    static class ApiTimeout {
        private int secs;
        private int nanos;

        ApiTimeout() {
        }

        public ApiTimeout withSecs(int secs) {
            this.secs = secs;
            return this;
        }

        public ApiTimeout withNanos(int nanos) {
            this.nanos = nanos;
            return this;
        }

        public JsonObject getJson() {
            JsonObject o = new JsonObject();
            o.addProperty("secs", this.secs);
            o.addProperty("nanos", this.nanos);
            return o;
        }
    }

    static class RentStructure {
        private int vByteCost;
        private int vByteFactorKey;
        private int vByteFactorData;

        public RentStructure(int vByteCost, int vByteFactorKey, int vByteFactorData) {
            this.vByteCost = vByteCost;
            this.vByteFactorKey = vByteFactorKey;
            this.vByteFactorData = vByteFactorData;
        }

        public JsonObject getJson() {
            JsonObject o = new JsonObject();
            o.addProperty("vByteCost", this.vByteCost);
            o.addProperty("vByteFactorKey", this.vByteFactorKey);
            o.addProperty("vByteFactorData", this.vByteFactorData);
            return o;
        }
    }

    static class NodeSyncInterval {
        private int secs;
        private int nanos;

        NodeSyncInterval() {
        }

        public NodeSyncInterval withSecs(int secs) {
            this.secs = secs;
            return this;
        }

        public NodeSyncInterval withNanos(int nanos) {
            this.nanos = nanos;
            return this;
        }

        public JsonObject getJson() {
            JsonObject o = new JsonObject();
            o.addProperty("secs", this.secs);
            o.addProperty("nanos", this.nanos);
            return o;
        }
    }
}

