/*
 * Decompiled with CFR 0.152.
 */
package jota.model;

import java.util.ArrayList;
import java.util.List;
import jota.model.Transaction;
import jota.pow.ICurl;
import jota.pow.SpongeFactory;
import jota.utils.Converter;
import jota.utils.Signing;
import org.apache.commons.lang3.StringUtils;

public class Bundle
implements Comparable<Bundle> {
    public static String EMPTY_HASH = "999999999999999999999999999999999999999999999999999999999999999999999999999999999";
    private List<Transaction> transactions;
    private int length;

    public Bundle() {
        this(new ArrayList<Transaction>(), 0);
    }

    public Bundle(List<Transaction> transactions, int length) {
        this.transactions = transactions;
        this.length = length;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void addEntry(int signatureMessageLength, String address, long value, String tag, long timestamp) {
        if (this.getTransactions() == null) {
            this.transactions = new ArrayList<Transaction>(this.getTransactions());
        }
        for (int i = 0; i < signatureMessageLength; ++i) {
            Transaction trx = new Transaction(address, i == 0 ? value : 0L, tag, timestamp);
            this.transactions.add(trx);
        }
    }

    public void finalize(ICurl customCurl) {
        String hashInTrytes;
        int i;
        boolean foundValue;
        int[] hash = new int[243];
        int[] obsoleteTagTrits = new int[81];
        boolean valid = true;
        ICurl curl = customCurl == null ? SpongeFactory.create(SpongeFactory.Mode.KERL) : customCurl;
        do {
            curl.reset();
            for (i = 0; i < this.getTransactions().size(); ++i) {
                int[] valueTrits = Converter.trits(this.getTransactions().get(i).getValue(), 81);
                int[] timestampTrits = Converter.trits(this.getTransactions().get(i).getTimestamp(), 27);
                this.getTransactions().get(i).setCurrentIndex(i);
                int[] currentIndexTrits = Converter.trits(this.getTransactions().get(i).getCurrentIndex(), 27);
                this.getTransactions().get(i).setLastIndex(this.getTransactions().size() - 1);
                int[] lastIndexTrits = Converter.trits(this.getTransactions().get(i).getLastIndex(), 27);
                int[] t = Converter.trits(this.getTransactions().get(i).getAddress() + Converter.trytes(valueTrits) + this.getTransactions().get(i).getObsoleteTag() + Converter.trytes(timestampTrits) + Converter.trytes(currentIndexTrits) + Converter.trytes(lastIndexTrits));
                curl.absorb(t, 0, t.length);
            }
            curl.squeeze(hash, 0, hash.length);
            hashInTrytes = Converter.trytes(hash);
            int[] normalizedBundleValue = this.normalizedBundle(hashInTrytes);
            foundValue = false;
            for (int aNormalizedBundleValue : normalizedBundleValue) {
                if (aNormalizedBundleValue != 13) continue;
                foundValue = true;
                obsoleteTagTrits = Converter.trits(this.getTransactions().get(0).getObsoleteTag());
                Converter.increment(obsoleteTagTrits, 81);
                this.getTransactions().get(0).setObsoleteTag(Converter.trytes(obsoleteTagTrits));
            }
        } while (!(valid = !foundValue));
        for (i = 0; i < this.getTransactions().size(); ++i) {
            this.getTransactions().get(i).setBundle(hashInTrytes);
        }
    }

    public void addTrytes(List<String> signatureFragments) {
        String emptySignatureFragment = "";
        String emptyHash = EMPTY_HASH;
        long emptyTimestamp = 999999999L;
        emptySignatureFragment = StringUtils.rightPad((String)emptySignatureFragment, (int)2187, (char)'9');
        for (int i = 0; i < this.getTransactions().size(); ++i) {
            this.getTransactions().get(i).setSignatureFragments(signatureFragments.size() <= i || signatureFragments.get(i).isEmpty() ? emptySignatureFragment : signatureFragments.get(i));
            this.getTransactions().get(i).setTrunkTransaction(emptyHash);
            this.getTransactions().get(i).setBranchTransaction(emptyHash);
            this.getTransactions().get(i).setAttachmentTimestamp(emptyTimestamp);
            this.getTransactions().get(i).setAttachmentTimestampLowerBound(emptyTimestamp);
            this.getTransactions().get(i).setAttachmentTimestampUpperBound(emptyTimestamp);
            this.getTransactions().get(i).setNonce(StringUtils.rightPad((String)"", (int)27, (String)"9"));
        }
    }

    public int[] normalizedBundle(String bundleHash) {
        return new Signing().normalizedBundle(bundleHash);
    }

    @Override
    public int compareTo(Bundle o) {
        return Long.compare(this.getTransactions().get(0).getAttachmentTimestamp(), o.getTransactions().get(0).getAttachmentTimestamp());
    }
}

