/*
 * Decompiled with CFR 0.152.
 */
package jota.model;

import java.util.Arrays;
import jota.pow.ICurl;
import jota.pow.SpongeFactory;
import jota.utils.Constants;
import jota.utils.Converter;
import jota.utils.InputValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final transient Logger log = LoggerFactory.getLogger(Transaction.class);
    private transient ICurl customCurl;
    private String hash;
    private String signatureFragments;
    private String address;
    private long value;
    private String obsoleteTag;
    private long timestamp;
    private long currentIndex;
    private long lastIndex;
    private String bundle;
    private String trunkTransaction;
    private String branchTransaction;
    private String nonce;
    private Boolean persistence;
    private long attachmentTimestamp;
    private String tag;
    private long attachmentTimestampLowerBound;
    private long attachmentTimestampUpperBound;

    public static Transaction[] asTransactionObjects(String ... trytes) {
        Transaction[] transactions = new Transaction[trytes.length];
        for (int i = 0; i < trytes.length; ++i) {
            transactions[i] = Transaction.asTransactionObject(trytes[i]);
        }
        return transactions;
    }

    public static Transaction asTransactionObject(String trytes) {
        return new Transaction(trytes);
    }

    public Transaction(String signatureFragments, long currentIndex, long lastIndex, String nonce, String hash, String obsoleteTag, long timestamp, String trunkTransaction, String branchTransaction, String address, long value, String bundle, String tag, long attachmentTimestamp, long attachmentTimestampLowerBound, long attachmentTimestampUpperBound) {
        this.hash = hash;
        this.obsoleteTag = obsoleteTag;
        this.signatureFragments = signatureFragments;
        this.address = address;
        this.value = value;
        this.timestamp = timestamp;
        this.currentIndex = currentIndex;
        this.lastIndex = lastIndex;
        this.bundle = bundle;
        this.trunkTransaction = trunkTransaction;
        this.branchTransaction = branchTransaction;
        this.tag = tag;
        this.attachmentTimestamp = attachmentTimestamp;
        this.attachmentTimestampLowerBound = attachmentTimestampLowerBound;
        this.attachmentTimestampUpperBound = attachmentTimestampUpperBound;
        this.nonce = nonce;
    }

    public Transaction(String address, long value, String tag, long timestamp) {
        this.address = address;
        this.value = value;
        this.tag = tag;
        this.obsoleteTag = tag;
        this.timestamp = timestamp;
    }

    public Transaction(ICurl curl) {
        this.customCurl = curl;
    }

    public Transaction() {
        this.customCurl = null;
    }

    public Transaction(String trytes) {
        this.transactionObject(trytes);
    }

    public Transaction(String trytes, ICurl customCurl) {
        this.transactionObject(trytes);
        this.customCurl = customCurl;
    }

    public long getAttachmentTimestampLowerBound() {
        return this.attachmentTimestampLowerBound;
    }

    public void setAttachmentTimestampLowerBound(long attachmentTimestampLowerBound) {
        this.attachmentTimestampLowerBound = attachmentTimestampLowerBound;
    }

    public long getAttachmentTimestampUpperBound() {
        return this.attachmentTimestampUpperBound;
    }

    public void setAttachmentTimestampUpperBound(long attachmentTimestampUpperBound) {
        this.attachmentTimestampUpperBound = attachmentTimestampUpperBound;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSignatureFragments() {
        return this.signatureFragments;
    }

    public void setSignatureFragments(String signatureFragments) {
        this.signatureFragments = signatureFragments;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(long currentIndex) {
        this.currentIndex = currentIndex;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(long lastIndex) {
        this.lastIndex = lastIndex;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getTrunkTransaction() {
        return this.trunkTransaction;
    }

    public void setTrunkTransaction(String trunkTransaction) {
        this.trunkTransaction = trunkTransaction;
    }

    public String getBranchTransaction() {
        return this.branchTransaction;
    }

    public void setBranchTransaction(String branchTransaction) {
        this.branchTransaction = branchTransaction;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Boolean getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Boolean persistence) {
        this.persistence = persistence;
    }

    public String getObsoleteTag() {
        return this.obsoleteTag;
    }

    public void setObsoleteTag(String obsoleteTag) {
        this.obsoleteTag = obsoleteTag;
    }

    public long getAttachmentTimestamp() {
        return this.attachmentTimestamp;
    }

    public void setAttachmentTimestamp(long attachmentTimestamp) {
        this.attachmentTimestamp = attachmentTimestamp;
    }

    public boolean equals(Object obj) {
        return obj != null && ((Transaction)obj).getHash().equals(this.getHash());
    }

    public String toTrytes() {
        int[] valueTrits = Converter.trits(this.getValue(), 81);
        int[] timestampTrits = Converter.trits(this.getTimestamp(), 27);
        int[] currentIndexTrits = Converter.trits(this.getCurrentIndex(), 27);
        int[] lastIndexTrits = Converter.trits(this.getLastIndex(), 27);
        int[] attachmentTimestampTrits = Converter.trits(this.getAttachmentTimestamp(), 27);
        int[] attachmentTimestampLowerBoundTrits = Converter.trits(this.getAttachmentTimestampLowerBound(), 27);
        int[] attachmentTimestampUpperBoundTrits = Converter.trits(this.getAttachmentTimestampUpperBound(), 27);
        this.tag = this.tag != null && !this.tag.isEmpty() ? this.tag : this.obsoleteTag;
        return this.getSignatureFragments() + this.getAddress() + Converter.trytes(valueTrits) + this.getObsoleteTag() + Converter.trytes(timestampTrits) + Converter.trytes(currentIndexTrits) + Converter.trytes(lastIndexTrits) + this.getBundle() + this.getTrunkTransaction() + this.getBranchTransaction() + this.getTag() + Converter.trytes(attachmentTimestampTrits) + Converter.trytes(attachmentTimestampLowerBoundTrits) + Converter.trytes(attachmentTimestampUpperBoundTrits) + this.getNonce();
    }

    public void transactionObject(String trytes) {
        if (StringUtils.isEmpty((CharSequence)trytes)) {
            log.warn("Warning: empty trytes in input for transactionObject");
            return;
        }
        if (!InputValidator.isNinesTrytes(trytes.substring(2279, 2295), 16)) {
            log.warn("Trytes {} does not seem a valid tryte", (Object)trytes);
            return;
        }
        int[] transactionTrits = Converter.trits(trytes);
        int[] hash = new int[Constants.HASH_LENGTH_TRITS];
        ICurl curl = SpongeFactory.create(SpongeFactory.Mode.CURLP81);
        curl.reset();
        curl.absorb(transactionTrits, 0, transactionTrits.length);
        curl.squeeze(hash, 0, hash.length);
        this.setHash(Converter.trytes(hash));
        this.setSignatureFragments(trytes.substring(0, Constants.MESSAGE_LENGTH));
        this.setAddress(trytes.substring(Constants.MESSAGE_LENGTH, Constants.MESSAGE_LENGTH + Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM));
        this.setValue(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6804, 6837)));
        this.setObsoleteTag(trytes.substring(2295, 2295 + Constants.TAG_LENGTH));
        this.setTimestamp(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6966, 6993)));
        this.setCurrentIndex(Converter.longValue(Arrays.copyOfRange(transactionTrits, 6993, 7020)));
        this.setLastIndex(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7020, 7047)));
        this.setBundle(trytes.substring(2349, 2349 + Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM));
        this.setTrunkTransaction(trytes.substring(2430, 2430 + Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM));
        this.setBranchTransaction(trytes.substring(2511, 2511 + Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM));
        this.setTag(trytes.substring(2592, 2592 + Constants.TAG_LENGTH));
        this.setAttachmentTimestamp(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7857, 7884)));
        this.setAttachmentTimestampLowerBound(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7884, 7911)));
        this.setAttachmentTimestampUpperBound(Converter.longValue(Arrays.copyOfRange(transactionTrits, 7911, 7938)));
        this.setNonce(trytes.substring(2646, 2673));
    }

    public boolean isTailTransaction() {
        return this.getCurrentIndex() == 0L;
    }
}

