/*
 * Decompiled with CFR 0.152.
 */
package jota.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import jota.error.ArgumentException;
import jota.model.Input;
import jota.model.Transfer;
import jota.utils.Constants;
import org.apache.commons.lang3.math.NumberUtils;

public class InputValidator {
    public static boolean isAddress(String address) {
        return (address.length() == Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM || address.length() == Constants.ADDRESS_LENGTH_WITH_CHECKSUM) && InputValidator.isTrytes(address);
    }

    public static boolean isAddressesCollectionValid(List<String> addresses) throws ArgumentException {
        for (String address : addresses) {
            if (InputValidator.checkAddress(address)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAddressesArrayValid(String[] addresses) throws ArgumentException {
        for (String address : addresses) {
            if (InputValidator.checkAddress(address)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAddress(String address) throws ArgumentException {
        if (!InputValidator.isAddress(address)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
        return true;
    }

    public static boolean isTrytes(String trytes) {
        return InputValidator.isTrytesOfExactLength(trytes, 0);
    }

    public static boolean isTrytesOfExactLength(String trytes, int length) {
        if (length < 0) {
            return false;
        }
        return trytes.matches("^[A-Z9]{" + (length == 0 ? "0," : Integer.valueOf(length)) + "}$");
    }

    public static boolean isTrytesOfMaxLength(String trytes, int maxLength) {
        if (trytes.length() > maxLength) {
            return false;
        }
        return InputValidator.isTrytesOfExactLength(trytes, 0);
    }

    public static boolean isEmptyTrytes(String trytes) {
        return InputValidator.isNinesTrytes(trytes, 0);
    }

    public static boolean isNinesTrytes(String trytes, int length) {
        return trytes.matches("^[9]{" + (length == 0 ? "0," : Integer.valueOf(length)) + "}$");
    }

    public static boolean isValue(String value) {
        return NumberUtils.isCreatable((String)value);
    }

    @Deprecated
    public static boolean isArrayOfTrytes(String[] trytes) {
        for (String tryte : trytes) {
            if (InputValidator.isTrytesOfExactLength(tryte, Constants.TRANSACTION_SIZE)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayOfHashes(String[] hashes) {
        if (hashes == null) {
            return false;
        }
        for (String hash : hashes) {
            if (InputValidator.isHash(hash)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTransfersCollectionValid(List<Transfer> transfers) throws ArgumentException {
        if (transfers == null || transfers.isEmpty()) {
            throw new ArgumentException("Invalid transfers provided.");
        }
        for (Transfer transfer : transfers) {
            if (InputValidator.isValidTransfer(transfer)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidTransfer(Transfer transfer) {
        if (transfer == null) {
            return false;
        }
        if (!InputValidator.isAddress(transfer.getAddress())) {
            return false;
        }
        if (transfer.getMessage() == null || !InputValidator.isTrytesOfExactLength(transfer.getMessage(), transfer.getMessage().length())) {
            return false;
        }
        return InputValidator.isValidTag(transfer.getTag());
    }

    public static boolean areValidTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return false;
        }
        for (String tag : tags) {
            if (InputValidator.isValidTag(tag)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidTag(String tag) {
        return tag != null && tag.length() <= Constants.TAG_LENGTH && InputValidator.isTrytes(tag);
    }

    public static boolean areValidInputs(Input ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return false;
        }
        for (Input input : inputs) {
            if (InputValidator.isValidInput(input)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidInput(Input input) {
        if (input == null) {
            return false;
        }
        if (!InputValidator.isAddress(input.getAddress())) {
            return false;
        }
        if (input.getKeyIndex() < 0) {
            return false;
        }
        return InputValidator.isValidSecurityLevel(input.getSecurity());
    }

    public static boolean isValidSeed(String seed) {
        if (seed.length() > 81) {
            return false;
        }
        return InputValidator.isTrytes(seed);
    }

    public static boolean isHashes(List<String> hashes) {
        if (hashes == null || hashes.size() == 0) {
            return false;
        }
        for (String hash : hashes) {
            if (InputValidator.isHash(hash)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHash(String hash) {
        if (hash.length() == Constants.ADDRESS_LENGTH_WITH_CHECKSUM) {
            return InputValidator.isTrytesOfExactLength(hash, 0);
        }
        return InputValidator.isTrytesOfExactLength(hash, Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM);
    }

    public static boolean areValidUris(String ... uris) {
        if (uris == null || uris.length == 0) {
            return false;
        }
        for (String uri : uris) {
            if (InputValidator.isValidUri(uri)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidUri(String uri) {
        if (uri.length() < 7) {
            return false;
        }
        String protocol = uri.substring(0, 6);
        if (!"tcp://".equals(protocol) && !"udp://".equals(protocol)) {
            return false;
        }
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean areTransactionTrytes(String ... trytes) {
        for (String tryteValue : trytes) {
            if (InputValidator.isTrytesOfExactLength(tryteValue, Constants.TRANSACTION_SIZE)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayOfAttachedTrytes(String[] trytes) {
        for (String tryteValue : trytes) {
            if (!InputValidator.isTrytesOfExactLength(tryteValue, Constants.TRANSACTION_SIZE)) {
                return false;
            }
            String lastTrytes = tryteValue.substring(Constants.TRANSACTION_SIZE - 243);
            if (!InputValidator.isNinesTrytes(lastTrytes, lastTrytes.length())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSecurityLevel(int level) {
        return level >= Constants.MIN_SECURITY_LEVEL && level <= Constants.MAX_SECURITY_LEVEL;
    }
}

