/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.iota.jota.ApiOptions;
import org.iota.jota.IotaAPICommand;
import org.iota.jota.IotaPoW;
import org.iota.jota.connection.Connection;
import org.iota.jota.dto.request.IotaAttachToTangleRequest;
import org.iota.jota.dto.request.IotaBroadcastTransactionRequest;
import org.iota.jota.dto.request.IotaCheckConsistencyRequest;
import org.iota.jota.dto.request.IotaCommandRequest;
import org.iota.jota.dto.request.IotaFindTransactionsRequest;
import org.iota.jota.dto.request.IotaGetBalancesRequest;
import org.iota.jota.dto.request.IotaGetInclusionStateRequest;
import org.iota.jota.dto.request.IotaGetTransactionsToApproveRequest;
import org.iota.jota.dto.request.IotaGetTrytesRequest;
import org.iota.jota.dto.request.IotaNeighborsRequest;
import org.iota.jota.dto.request.IotaStoreTransactionsRequest;
import org.iota.jota.dto.request.IotaWereAddressesSpentFromRequest;
import org.iota.jota.dto.response.AddNeighborsResponse;
import org.iota.jota.dto.response.BroadcastTransactionsResponse;
import org.iota.jota.dto.response.CheckConsistencyResponse;
import org.iota.jota.dto.response.FindTransactionResponse;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetBalancesResponse;
import org.iota.jota.dto.response.GetInclusionStateResponse;
import org.iota.jota.dto.response.GetNeighborsResponse;
import org.iota.jota.dto.response.GetNodeInfoResponse;
import org.iota.jota.dto.response.GetTipsResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.InterruptAttachingToTangleResponse;
import org.iota.jota.dto.response.RemoveNeighborsResponse;
import org.iota.jota.dto.response.StoreTransactionsResponse;
import org.iota.jota.dto.response.WereAddressesSpentFromResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Transaction;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotaAPICore {
    private static final Logger log = LoggerFactory.getLogger(IotaAPICore.class);
    private ApiOptions options;
    protected final List<Connection> nodes = new ArrayList<Connection>();

    protected IotaAPICore(ApiOptions options) {
        this.options = options;
        for (Connection c : options.getNodes()) {
            this.addNode(c);
        }
    }

    public boolean hasNodes() {
        return this.nodes != null && this.nodes.size() > 0;
    }

    public Connection getRandomNode() {
        if (!this.hasNodes()) {
            return null;
        }
        return this.nodes.get(new Random().nextInt(this.nodes.size()));
    }

    public List<Connection> getNodes() {
        return this.nodes;
    }

    ApiOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(Connection n) {
        try {
            List<Connection> list = this.nodes;
            synchronized (list) {
                for (Connection c : this.nodes) {
                    if (!c.equals(n)) continue;
                    log.warn("Tried to add a node we allready have: " + n);
                    return true;
                }
                boolean started = n.start();
                if (started) {
                    this.nodes.add(n);
                    log.debug("Added node: " + n.toString());
                }
                return started;
            }
        }
        catch (Exception e) {
            log.warn("Failed to add node connection to pool due to " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(Connection n) {
        List<Connection> list = this.nodes;
        synchronized (list) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Connection c = this.nodes.get(i);
                if (!c.equals(n)) continue;
                c.stop();
                this.nodes.remove(i);
                return true;
            }
        }
        return false;
    }

    public ICurl getCurl() {
        return this.getOptions().getCustomCurl().clone();
    }

    public void setCurl(ICurl localPoW) {
        this.getOptions().setCustomCurl(localPoW);
    }

    public IotaPoW getLocalPoW() {
        return this.getOptions().getLocalPoW();
    }

    public void setLocalPoW(IotaPoW localPoW) {
        this.getOptions().setLocalPoW(localPoW);
    }

    private Connection getNodeFor(IotaAPICommand cmd) {
        if (null == cmd) {
            return this.nodes.get(0);
        }
        return this.nodes.get(0);
    }

    public GetNodeInfoResponse getNodeInfo() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_NODE_INFO).getNodeInfo(IotaCommandRequest.createNodeInfoRequest());
    }

    public GetNeighborsResponse getNeighbors() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_NEIGHBORS).getNeighbors(IotaCommandRequest.createGetNeighborsRequest());
    }

    public AddNeighborsResponse addNeighbors(String ... uris) throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.ADD_NEIGHBORS).addNeighbors(IotaNeighborsRequest.createAddNeighborsRequest(uris));
    }

    public RemoveNeighborsResponse removeNeighbors(String ... uris) throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.REMOVE_NEIGHBORS).removeNeighbors(IotaNeighborsRequest.createRemoveNeighborsRequest(uris));
    }

    public GetTipsResponse getTips() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.GET_TIPS).getTips(IotaCommandRequest.createGetTipsRequest());
    }

    public FindTransactionResponse findTransactions(String[] addresses, String[] tags, String[] approvees, String[] bundles) throws ArgumentException {
        String[] addressesWithoutChecksum;
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            this.validateAddresses(addresses);
            addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        } else {
            addressesWithoutChecksum = addresses;
        }
        if (ArrayUtils.isNotEmpty((Object[])tags)) {
            this.validateTags(tags);
        }
        if (ArrayUtils.isNotEmpty((Object[])bundles)) {
            this.validateBundles(bundles);
        }
        if (ArrayUtils.isNotEmpty((Object[])approvees)) {
            this.validateApprovees(approvees);
        }
        IotaFindTransactionsRequest findTransRequest = IotaFindTransactionsRequest.createFindTransactionRequest().byAddresses(addressesWithoutChecksum).byTags(tags).byApprovees(approvees).byBundles(bundles);
        return this.getNodeFor(IotaAPICommand.FIND_TRANSACTIONS).findTransactions(findTransRequest);
    }

    public FindTransactionResponse findTransactionsByAddresses(String ... addresses) throws ArgumentException {
        this.validateAddresses(addresses);
        return this.findTransactions(addresses, null, null, null);
    }

    public FindTransactionResponse findTransactionsByBundles(String ... bundles) throws ArgumentException {
        return this.findTransactions(null, null, null, bundles);
    }

    public FindTransactionResponse findTransactionsByApprovees(String ... approvees) throws ArgumentException {
        return this.findTransactions(null, null, approvees, null);
    }

    @Deprecated
    public FindTransactionResponse findTransactionsByDigests(String ... digests) throws ArgumentException {
        return this.findTransactionsByTags(digests);
    }

    public FindTransactionResponse findTransactionsByTags(String ... tags) throws ArgumentException {
        return this.findTransactions(null, tags, null, null);
    }

    public GetInclusionStateResponse getInclusionStates(String[] transactions, String[] tips) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(transactions)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.GET_INCLUSIONS_STATES).getInclusionStates(IotaGetInclusionStateRequest.createGetInclusionStateRequest(transactions, tips));
    }

    public GetTrytesResponse getTrytes(String ... hashes) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(hashes)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.GET_TRYTES).getTrytes(IotaGetTrytesRequest.createGetTrytesRequest(hashes));
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth, String reference) throws ArgumentException {
        if (depth < 0) {
            throw new ArgumentException("Invalid depth provided. (Between 0 and 15, soft upper bound)");
        }
        return this.getNodeFor(IotaAPICommand.GET_TRANSACTIONS_TO_APPROVE).getTransactionsToApprove(IotaGetTransactionsToApproveRequest.createIotaGetTransactionsToApproveRequest(depth, reference));
    }

    public GetTransactionsToApproveResponse getTransactionsToApprove(Integer depth) throws ArgumentException {
        return this.getTransactionsToApprove(depth, null);
    }

    public GetBalancesResponse getBalances(Integer threshold, String[] addresses, String[] tips) throws ArgumentException {
        if (threshold < 0 || threshold > 100) {
            throw new ArgumentException("Invalid threshold provided. (Between 0 and 100 incl.)");
        }
        if (null != tips && !InputValidator.isArrayOfHashes(tips)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        this.validateAddresses(addresses);
        String[] addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        return this.getNodeFor(IotaAPICommand.GET_BALANCES).getBalances(IotaGetBalancesRequest.createIotaGetBalancesRequest(threshold, addressesWithoutChecksum, tips));
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses, List<String> tips) throws ArgumentException {
        String[] tipsArray = tips != null ? tips.toArray(new String[0]) : null;
        String[] addressesArray = addresses != null ? addresses.toArray(new String[0]) : null;
        return this.getBalances(threshold, addressesArray, tipsArray);
    }

    public GetBalancesResponse getBalances(Integer threshold, List<String> addresses) throws ArgumentException {
        return this.getBalances(threshold, addresses, null);
    }

    public WereAddressesSpentFromResponse wereAddressesSpentFrom(String ... addresses) throws ArgumentException {
        this.validateAddresses(addresses);
        String[] addressesWithoutChecksum = this.removeChecksumFromAddresses(addresses);
        return this.getNodeFor(IotaAPICommand.WERE_ADDRESSES_SPENT_FROM).wereAddressesSpentFrom(IotaWereAddressesSpentFromRequest.create(addressesWithoutChecksum));
    }

    public CheckConsistencyResponse checkConsistency(String ... tails) throws ArgumentException {
        if (!InputValidator.isArrayOfHashes(tails)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        return this.getNodeFor(IotaAPICommand.CHECK_CONSISTENCY).checkConsistency(IotaCheckConsistencyRequest.create(tails));
    }

    public GetAttachToTangleResponse attachToTangle(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, String ... trytes) throws ArgumentException {
        IotaPoW pow = this.getOptions().getLocalPoW();
        if (pow != null) {
            return this.attachToTangleLocalPow(trunkTransaction, branchTransaction, minWeightMagnitude, pow, trytes);
        }
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        IotaAttachToTangleRequest attachToTangleRequest = IotaAttachToTangleRequest.createAttachToTangleRequest(trunkTransaction, branchTransaction, minWeightMagnitude, trytes);
        return this.getNodeFor(IotaAPICommand.ATTACH_TO_TANGLE).attachToTangle(attachToTangleRequest);
    }

    public GetAttachToTangleResponse attachToTangleLocalPow(String trunkTransaction, String branchTransaction, Integer minWeightMagnitude, IotaPoW pow, String ... trytes) {
        if (pow == null) {
            log.warn("Called local POW without POW defined, switching to remote POW");
            return this.attachToTangle(trunkTransaction, branchTransaction, minWeightMagnitude, trytes);
        }
        if (!InputValidator.isHash(trunkTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isHash(branchTransaction)) {
            throw new ArgumentException("Invalid hashes provided.");
        }
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid trytes provided.");
        }
        String[] resultTrytes = new String[trytes.length];
        String previousTransaction = null;
        try {
            for (int i = 0; i < resultTrytes.length; ++i) {
                Transaction txn = new Transaction(trytes[i]);
                txn.setTrunkTransaction(previousTransaction == null ? trunkTransaction : previousTransaction);
                txn.setBranchTransaction(previousTransaction == null ? branchTransaction : trunkTransaction);
                if (txn.getTag().isEmpty() || txn.getTag().matches("9*")) {
                    txn.setTag(txn.getObsoleteTag());
                }
                txn.setAttachmentTimestamp(System.currentTimeMillis());
                txn.setAttachmentTimestampLowerBound(0L);
                txn.setAttachmentTimestampUpperBound(3812798742493L);
                resultTrytes[i] = pow.performPoW(txn.toTrytes(), minWeightMagnitude);
                previousTransaction = new Transaction(resultTrytes[i], SpongeFactory.create(SpongeFactory.Mode.CURLP81)).getHash();
            }
            Collections.reverse(Arrays.asList(resultTrytes));
        }
        catch (Exception e) {
            throw new ArgumentException("Could not compute PoW trytes", e);
        }
        return new GetAttachToTangleResponse(resultTrytes);
    }

    public InterruptAttachingToTangleResponse interruptAttachingToTangle() throws ArgumentException {
        return this.getNodeFor(IotaAPICommand.INTERRUPT_ATTACHING_TO_TANGLE).interruptAttachingToTangle(IotaCommandRequest.createInterruptAttachToTangleRequest());
    }

    public BroadcastTransactionsResponse broadcastTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.getNodeFor(IotaAPICommand.BROADCAST_TRANSACTIONS).broadcastTransactions(IotaBroadcastTransactionRequest.createBroadcastTransactionsRequest(trytes));
    }

    public StoreTransactionsResponse storeTransactions(String ... trytes) throws ArgumentException {
        if (!InputValidator.isArrayOfRawTransactionTrytes(trytes)) {
            throw new ArgumentException("Invalid attached trytes provided.");
        }
        return this.getNodeFor(IotaAPICommand.STORE_TRANSACTIONS).storeTransactions(IotaStoreTransactionsRequest.createStoreTransactionsRequest(trytes));
    }

    private void validateAddresses(String[] addresses) {
        if (ArrayUtils.isEmpty((Object[])addresses) || !InputValidator.isAddressesArrayValid(addresses)) {
            throw new ArgumentException("Invalid addresses provided.");
        }
    }

    private String[] removeChecksumFromAddresses(String[] addresses) {
        String[] addressesWithoutChecksum = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            addressesWithoutChecksum[i] = Checksum.removeChecksum(addresses[i]);
        }
        return addressesWithoutChecksum;
    }

    private void validateTags(String[] tags) {
        if (!InputValidator.areValidTags(tags)) {
            throw new ArgumentException("Invalid tag provided.");
        }
    }

    private void validateBundles(String[] bundles) {
        if (!InputValidator.isArrayOfHashes(bundles)) {
            throw new ArgumentException("Invalid bundle hash.");
        }
    }

    private void validateApprovees(String[] bundles) {
        if (!InputValidator.isArrayOfHashes(bundles)) {
            throw new ArgumentException("Invalid bundle hash.");
        }
    }

    @Deprecated
    public String getProtocol() {
        return this.getNodeFor(null).url().getProtocol();
    }

    @Deprecated
    public String getHost() {
        return this.getNodeFor(null).url().getHost();
    }

    @Deprecated
    public String getPort() {
        return this.getNodeFor(null).url().getPort() + "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----------------------");
        builder.append(System.getProperty("line.separator"));
        builder.append(this.getOptions().toString());
        builder.append(System.getProperty("line.separator"));
        builder.append("Registered nodes: ");
        builder.append(System.getProperty("line.separator"));
        this.nodes.forEach(node -> builder.append(node.toString()).append(System.getProperty("line.separator")));
        return builder.toString();
    }
}

