/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.Account;
import org.iota.jota.account.AccountBalanceCache;
import org.iota.jota.account.AccountOptions;
import org.iota.jota.account.AccountState;
import org.iota.jota.account.AccountStateManager;
import org.iota.jota.account.AccountStore;
import org.iota.jota.account.addressgenerator.AddressGeneratorServiceImpl;
import org.iota.jota.account.condition.ExpireCondition;
import org.iota.jota.account.deposits.ConditionalDepositAddress;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.account.errors.AccountLoadError;
import org.iota.jota.account.errors.SendException;
import org.iota.jota.account.event.AccountEvent;
import org.iota.jota.account.event.EventListener;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.account.event.events.EventAccountError;
import org.iota.jota.account.event.events.EventAttachingToTangle;
import org.iota.jota.account.event.events.EventDoingProofOfWork;
import org.iota.jota.account.event.events.EventNewInput;
import org.iota.jota.account.event.events.EventSentTransfer;
import org.iota.jota.account.event.events.EventShutdown;
import org.iota.jota.account.event.impl.EventManagerImpl;
import org.iota.jota.account.inputselector.InputSelectionStrategyImpl;
import org.iota.jota.account.plugins.Plugin;
import org.iota.jota.account.plugins.promoter.PromoterReattacherImpl;
import org.iota.jota.account.plugins.transferchecker.IncomingTransferCheckerImpl;
import org.iota.jota.account.plugins.transferchecker.OutgoingTransferCheckerImpl;
import org.iota.jota.account.seedprovider.SeedProvider;
import org.iota.jota.builder.AccountBuilder;
import org.iota.jota.config.options.AccountConfig;
import org.iota.jota.config.types.FileConfig;
import org.iota.jota.dto.response.GetAttachToTangleResponse;
import org.iota.jota.dto.response.GetTransactionsToApproveResponse;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Input;
import org.iota.jota.model.Transaction;
import org.iota.jota.model.Transfer;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.types.Address;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Recipient;
import org.iota.jota.types.Trytes;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;
import org.iota.jota.utils.IotaAPIUtils;
import org.iota.jota.utils.TrytesConverter;
import org.iota.jota.utils.thread.TaskService;
import org.iota.mddoclet.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotaAccount
implements Account,
EventListener {
    private static final String ACC_START_FAILED = "Failed to load accounts. Check the error log";
    private static final Logger log = LoggerFactory.getLogger(IotaAccount.class);
    private AccountOptions options;
    private EventManager eventManager;
    List<Plugin> tasks = new ArrayList<Plugin>();
    private AccountStateManager accountManager;
    boolean loaded = false;
    String accountId = null;
    private AddressGeneratorServiceImpl addressService;
    private AccountBalanceCache balanceCache;

    public IotaAccount(AccountOptions options) {
        this.options = options;
        this.eventManager = new EventManagerImpl();
        this.getEventManager().registerListener(this);
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.loaded) {
            throw new AccountLoadError(ACC_START_FAILED);
        }
        this.start();
    }

    protected IotaAccount(AccountBuilder builder) {
        this(new AccountOptions(builder));
    }

    public IotaAccount(String seed) throws Exception {
        this(new AccountBuilder(seed).generate());
    }

    public IotaAccount(String seed, AccountStore store) throws Exception {
        this(new AccountBuilder(seed).store(store).generate());
    }

    public IotaAccount(String seed, AccountStore store, String config) throws Exception {
        this(((AccountBuilder)new AccountBuilder(seed).store(store).config(new FileConfig(config))).generate());
    }

    public IotaAccount(String seed, AccountStore store, AccountConfig iotaConfig) throws Exception {
        this(((AccountBuilder)new AccountBuilder(seed).store(store).config(iotaConfig)).generate());
    }

    @Override
    public void load() {
        String accountId = this.buildAccountId();
        if (this.options.getStore() instanceof TaskService) {
            try {
                ((TaskService)((Object)this.options.getStore())).load();
            }
            catch (Exception e) {
                throw new AccountError(e);
            }
        }
        this.load(accountId, this.getStore().loadAccount(accountId));
    }

    private String buildAccountId() {
        return IotaAPIUtils.newAddress(this.getSeed().getSeed().toString(), 2, 0, false, this.getApi().getCurl());
    }

    public void load(String accountId, AccountState state) throws AccountError {
        this.loaded = false;
        this.accountId = accountId;
        this.addressService = new AddressGeneratorServiceImpl(this.options);
        this.balanceCache = new AccountBalanceCache(this.addressService, state, this.getApi());
        InputSelectionStrategyImpl strategy = new InputSelectionStrategyImpl(this.balanceCache, this.options.getTime());
        this.accountManager = new AccountStateManager(this.balanceCache, accountId, strategy, state, this.addressService, this.options, this.getStore());
        this.addTask(new PromoterReattacherImpl(this.eventManager, this.getApi(), this.accountManager, this.options));
        this.addTask(new IncomingTransferCheckerImpl(this.eventManager, this.getApi(), this.accountManager, this.addressService, this.balanceCache, true));
        this.addTask(new OutgoingTransferCheckerImpl(this.eventManager, this.getApi(), this.accountManager));
        if (this.options.getPlugins() != null) {
            for (Plugin customPlugin : this.options.getPlugins()) {
                this.addTask(customPlugin);
            }
        }
        this.shutdownHook();
        try {
            this.getApi().getNodeInfo();
        }
        catch (ArgumentException e) {
            throw new AccountLoadError(e);
        }
        this.loaded = true;
    }

    private void shutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Shutting down IOTA Accounts, please hold tight...");
            try {
                this.shutdown();
            }
            catch (Exception e) {
                log.error("Exception occurred shutting down accounts module: ", (Throwable)e);
            }
        }, "Shutdown Hook"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unload(boolean clearTasks) {
        if (this.options.getStore() instanceof TaskService) {
            ((TaskService)((Object)this.options.getStore())).shutdown();
        }
        List<Plugin> list = this.tasks;
        synchronized (list) {
            for (Plugin task : this.tasks) {
                this.getEventManager().unRegisterListener(task);
                task.shutdown();
                task.setAccount(null);
            }
            if (clearTasks) {
                this.tasks.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Plugin task) {
        List<Plugin> list = this.tasks;
        synchronized (list) {
            if (task != null) {
                try {
                    task.setAccount(this);
                    task.load();
                    this.getEventManager().registerListener(task);
                    this.tasks.add(task);
                    log.debug("Loaded plugin " + task.name());
                }
                catch (Exception e) {
                    throw new AccountError(e);
                }
            }
        }
    }

    @Override
    public String getId() throws AccountError {
        return this.accountId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() throws AccountError {
        if (this.options.getStore() instanceof TaskService && !((TaskService)((Object)this.options.getStore())).start()) {
            throw new AccountError("Store failed to start");
        }
        List<Plugin> list = this.tasks;
        synchronized (list) {
            for (Plugin task : this.tasks) {
                if (task.start()) continue;
            }
        }
        return true;
    }

    @Override
    public void shutdown() throws AccountError {
        Date now = this.options.getTime().time();
        this.unload(true);
        this.eventManager.emit(new EventShutdown(now));
    }

    @Override
    public long usableBalance() throws AccountError {
        return this.accountManager.getUsableBalance();
    }

    @Override
    public long totalBalance() throws AccountError {
        return this.accountManager.getTotalBalance();
    }

    @Override
    public boolean isNew() {
        return this.accountManager.isNew();
    }

    @Override
    public void updateSettings(AccountOptions newSettings) throws AccountError {
        this.shutdown();
        this.unload(false);
        this.options = newSettings;
        try {
            this.load();
            if (!this.start()) {
                throw new AccountError(ACC_START_FAILED);
            }
        }
        catch (AccountError e) {
            EventAccountError event = new EventAccountError(e);
            this.eventManager.emit(event);
            throw e;
        }
    }

    public Future<Bundle> send(String address, long amount, String message, String tag) {
        return this.send(address, amount, Optional.ofNullable(message), Optional.ofNullable(tag));
    }

    @Document
    public Future<Bundle> send(String address, long amount, Optional<String> message, Optional<String> tag) {
        FutureTask<Bundle> task = new FutureTask<Bundle>(() -> {
            if (!this.loaded) {
                return null;
            }
            if (amount == 0L) {
                return this.sendZeroValue(message, tag, Optional.ofNullable(address)).get();
            }
            String tryteTag = tag == null ? "" : tag.orElse("");
            if (!InputValidator.isTag(tryteTag = StringUtils.rightPad((String)tryteTag, (int)27, (char)'9'))) {
                throw new ArgumentException("Invalid tag provided.");
            }
            String asciiMessage = message == null ? "" : message.orElse("");
            String tryteMsg = TrytesConverter.asciiToTrytes(asciiMessage);
            if (!InputValidator.isTrytes(tryteMsg, tryteMsg.length())) {
                throw new ArgumentException("Invalid input provided.");
            }
            try {
                boolean spent = this.getApi().checkWereAddressSpentFrom(address);
                if (spent) {
                    throw new ArgumentException("Invalid address provided.");
                }
                Transfer transfer = new Transfer(address, amount, tryteMsg, tryteTag);
                List<Input> inputs = this.accountManager.getInputAddresses(amount);
                AtomicLong totalValue = new AtomicLong(0L);
                inputs.stream().forEach(input -> totalValue.addAndGet(input.getBalance()));
                Transfer remainder = null;
                if (totalValue.get() > amount) {
                    Input input2 = this.accountManager.createRemainder(totalValue.get() - amount);
                    remainder = new Transfer(input2.getAddress(), input2.getBalance(), "", tryteTag);
                }
                List<String> trytes = this.prepareTransfers(transfer, inputs, remainder);
                List<Transaction> transferResponse = this.sendTrytes(null, trytes.toArray(new String[0]));
                Trytes[] bundleTrytes = new Trytes[transferResponse.size()];
                for (int i = 0; i < transferResponse.size(); ++i) {
                    bundleTrytes[i] = new Trytes(transferResponse.get(i).toTrytes());
                }
                this.accountManager.addPendingTransfer(new Hash(transferResponse.get(0).getHash()), bundleTrytes, 1);
                Bundle bundle = new Bundle(transferResponse, transferResponse.size());
                EventSentTransfer event = new EventSentTransfer(bundle);
                this.eventManager.emit(event);
                return bundle;
            }
            catch (IllegalStateException | ArgumentException e) {
                EventAccountError event = new EventAccountError(e);
                this.eventManager.emit(event);
                return null;
            }
        });
        task.run();
        return task;
    }

    @Override
    public Future<ConditionalDepositAddress> newDepositAddress(Date timeOut, boolean multiUse, long expectedAmount, ExpireCondition ... otherConditions) throws AccountError {
        return this.newDepositRequest(new DepositRequest(timeOut, multiUse, expectedAmount), otherConditions);
    }

    public Future<ConditionalDepositAddress> newDepositRequest(DepositRequest request, ExpireCondition ... otherConditions) throws AccountError {
        FutureTask<ConditionalDepositAddress> task = new FutureTask<ConditionalDepositAddress>(() -> {
            if (request.getMultiUse() && request.getExpectedAmount() != 0L) {
                throw new AccountError("Cannot use multi-use and amount simultaneously");
            }
            Address address = this.accountManager.getNextAddress();
            StoredDepositAddress storedRequest = new StoredDepositAddress(request, this.options.getSecurityLevel());
            this.accountManager.addDepositRequest(address.getIndex(), storedRequest);
            this.balanceCache.addBalance(new Input(address.getAddress().getHashCheckSum(), 0L, address.getIndex(), this.options.getSecurityLevel()), request);
            EventNewInput event = new EventNewInput(address, request);
            this.eventManager.emit(event);
            return new ConditionalDepositAddress(request, address.getAddress());
        });
        task.run();
        return task;
    }

    @Override
    public Future<Bundle> send(Recipient recipient) throws AccountError {
        if (recipient.getAddresses().length == 1) {
            return recipient.getValue() == 0L ? this.sendZeroValue(recipient.getMessage(), recipient.getTag(), recipient.getAddresses()[0]) : this.send(recipient.getAddresses()[0], recipient.getValue(), Optional.of(recipient.getMessage()), Optional.of(recipient.getTag()));
        }
        return this.sendMulti(recipient.getAddresses(), recipient.getValue(), Optional.of(recipient.getMessage()), Optional.of(recipient.getTag()));
    }

    public Future<Bundle> sendZeroValue(String message, String tag, String address) throws ArgumentException, SendException {
        return this.sendZeroValue(Optional.ofNullable(message), Optional.ofNullable(tag), Optional.ofNullable(address));
    }

    public Future<Bundle> sendZeroValue(Optional<String> message, Optional<String> tag, Optional<String> address) throws ArgumentException, SendException {
        FutureTask<Bundle> task = new FutureTask<Bundle>(() -> {
            if (!this.loaded) {
                return null;
            }
            if (tag.isPresent() && !InputValidator.isTag((String)tag.get())) {
                throw new ArgumentException("Invalid tag provided.");
            }
            String addressHash = "999999999999999999999999999999999999999999999999999999999999999999999999999999999";
            if (address.isPresent()) {
                if (InputValidator.isAddress((String)address.get())) {
                    addressHash = Checksum.removeChecksum((String)address.get());
                } else {
                    throw new ArgumentException("Invalid address provided.");
                }
            }
            String tryteTag = tag.orElse("");
            tryteTag = StringUtils.rightPad((String)tryteTag, (int)27, (char)'9');
            String asciiMessage = message.orElse("IOTA Accounts Transfer");
            String tryteMsg = TrytesConverter.asciiToTrytes(asciiMessage);
            Transfer transfer = new Transfer(addressHash, 0L, tryteMsg, tryteTag);
            LinkedList<Transfer> transfers = new LinkedList<Transfer>();
            transfers.add(transfer);
            try {
                List<String> trytes = this.prepareTransfers(transfers);
                List<Transaction> transferResponse = this.sendTrytes(null, trytes.toArray(new String[0]));
                Bundle bundle = new Bundle(transferResponse, transferResponse.size());
                EventSentTransfer event = new EventSentTransfer(bundle);
                this.eventManager.emit(event);
                return bundle;
            }
            catch (ArgumentException e) {
                throw new AccountError(e);
            }
        });
        task.run();
        return task;
    }

    public Future<Bundle> sendMulti(String[] addresses, long amount, Optional<String> message, Optional<String> tag) {
        FutureTask<Bundle> task = new FutureTask<Bundle>(() -> {
            if (!this.loaded) {
                return null;
            }
            return null;
        });
        task.run();
        return task;
    }

    private List<String> prepareTransfers(Transfer transfer, List<Input> inputs, Transfer remainder) {
        LinkedList<Transfer> transfers = new LinkedList<Transfer>();
        transfers.add(transfer);
        inputs.stream().forEach(input -> {
            transfers.add(new Transfer(input.getAddress(), -input.getBalance(), "", transfer.getTag()));
            for (int i = 1; i < input.getSecurity(); ++i) {
                transfers.add(new Transfer(input.getAddress(), 0L, "", transfer.getTag()));
            }
        });
        if (remainder != null) {
            transfers.add(remainder);
        }
        Bundle bundle = new Bundle();
        List<String> signatureFragments = this.prepareBundle(bundle, transfers);
        try {
            List<String> output = IotaAPIUtils.signInputsAndReturn(this.getSeed().getSeed().getTrytesString(), inputs, bundle, signatureFragments, this.getApi().getCurl());
            return output;
        }
        catch (ArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> prepareTransfers(List<Transfer> transfers) {
        LinkedList<String> bundleTrytes = new LinkedList<String>();
        for (Transfer transfer2 : transfers) {
            if (transfer2.getValue() > 0L) {
                // empty if block
            }
            if (transfer2.getMessage().equals("")) continue;
        }
        AtomicLong totalValue = new AtomicLong(0L);
        transfers.stream().forEach(transfer -> totalValue.addAndGet(transfer.getValue()));
        Bundle bundle = new Bundle();
        List<String> signatureFragments = this.prepareBundle(bundle, transfers);
        bundle.finalize(this.getApi().getCurl());
        bundle.addTrytes(signatureFragments);
        List<Transaction> trxb = bundle.getTransactions();
        for (Transaction trx : trxb) {
            bundleTrytes.add(trx.toTrytes());
        }
        Collections.reverse(bundleTrytes);
        return bundleTrytes;
    }

    private List<String> prepareBundle(Bundle bundle, List<Transfer> transfers) {
        ArrayList<String> signatureFragments = new ArrayList<String>();
        for (Transfer transfer : transfers) {
            int signatureMessageLength = 1;
            if (transfer.getMessage().length() > 2187) {
                signatureMessageLength = (int)((double)signatureMessageLength + Math.floor(transfer.getMessage().length() / 2187));
                String msgCopy = transfer.getMessage();
                while (!msgCopy.isEmpty()) {
                    String fragment = StringUtils.substring((String)msgCopy, (int)0, (int)2187);
                    msgCopy = StringUtils.substring((String)msgCopy, (int)2187, (int)msgCopy.length());
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                    signatureFragments.add(fragment);
                }
            } else {
                String fragment = transfer.getMessage();
                if (transfer.getMessage().length() < 2187) {
                    fragment = StringUtils.rightPad((String)fragment, (int)2187, (char)'9');
                }
                signatureFragments.add(fragment);
            }
            long timestamp = (long)Math.floor(Calendar.getInstance().getTimeInMillis() / 1000L);
            bundle.addEntry(signatureMessageLength, transfer.getAddress(), transfer.getValue(), transfer.getTag(), timestamp);
        }
        return signatureFragments;
    }

    private List<Transaction> sendTrytes(Hash reference, String ... trytes) {
        GetAttachToTangleResponse res;
        GetTransactionsToApproveResponse txs = this.getApi().getTransactionsToApprove(this.options.getDepth(), reference == null ? null : reference.getHash());
        EventAttachingToTangle attach = new EventAttachingToTangle(trytes);
        this.getEventManager().emit(attach);
        if (this.getApi().getOptions().getLocalPoW() != null) {
            EventDoingProofOfWork eventPow = new EventDoingProofOfWork(trytes);
            this.getEventManager().emit(eventPow);
            res = this.getApi().attachToTangleLocalPow(txs.getTrunkTransaction(), txs.getBranchTransaction(), this.options.getMwm(), this.getApi().getOptions().getLocalPoW(), trytes);
        } else {
            res = this.getApi().attachToTangle(txs.getTrunkTransaction(), txs.getBranchTransaction(), this.options.getMwm(), trytes);
        }
        try {
            this.getApi().storeAndBroadcast(res.getTrytes());
        }
        catch (ArgumentException e) {
            return new ArrayList<Transaction>();
        }
        ArrayList<Transaction> trx = new ArrayList<Transaction>();
        for (String tryte : res.getTrytes()) {
            trx.add(new Transaction(tryte, SpongeFactory.create(SpongeFactory.Mode.CURLP81)));
        }
        return trx;
    }

    public AccountState exportAccount() {
        if (!this.loaded) {
            return null;
        }
        try {
            return this.getAccountManager().getAccountState().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAccount(AccountState state) {
        IotaAccount iotaAccount = this;
        synchronized (iotaAccount) {
            if (this.accountManager != null) {
                this.accountManager.save();
            }
            this.unload(true);
            this.load(this.accountId, state);
            this.accountManager.save();
        }
    }

    public SeedProvider getSeed() {
        return this.options.getSeed();
    }

    private AccountStore getStore() {
        return this.options.getStore();
    }

    public IotaAPI getApi() {
        return this.options.getApi();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public AccountStateManager getAccountManager() {
        return this.accountManager;
    }

    @AccountEvent
    private void onError(EventAccountError error) {
        if (error.shouldLog()) {
            log.error(error.getMessage(), error.getCause());
            error.getException().printStackTrace();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----------------------");
        builder.append(System.getProperty("line.separator"));
        builder.append("iota-java accounts configured with the following: ");
        builder.append(System.getProperty("line.separator"));
        builder.append(this.options.toString());
        return builder.toString();
    }

    public static class Builder
    extends AccountBuilder {
        public Builder(SeedProvider seed) throws ArgumentException {
            super(seed);
        }

        public Builder(String seed) throws ArgumentException {
            super(seed);
        }
    }
}

