/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.inputselector;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iota.jota.account.AccountBalanceCache;
import org.iota.jota.account.clock.Clock;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.account.errors.AccountNoBalanceError;
import org.iota.jota.account.inputselector.InputSelectionStrategy;
import org.iota.jota.account.plugins.AccountPlugin;
import org.iota.jota.model.Input;

public class InputSelectionStrategyImpl
extends AccountPlugin
implements InputSelectionStrategy {
    private Clock clock;
    private AccountBalanceCache cache;

    public InputSelectionStrategyImpl(AccountBalanceCache cache, Clock clock) {
        this.cache = cache;
        this.clock = clock;
    }

    @Override
    public List<Input> getInput(long requiredValue, boolean balanceCheck) {
        long remaining = requiredValue;
        if (balanceCheck) {
            // empty if block
        }
        List balances = this.cache.getStream().filter(entry -> this.isUsable((Input)entry.getKey(), (DepositRequest)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        LinkedList<Input> usedInputs = new LinkedList<Input>();
        for (Input i : balances) {
            usedInputs.add(i);
            if ((remaining -= i.getBalance()) > 0L) continue;
            break;
        }
        if (remaining > 0L) {
            throw new AccountNoBalanceError("Missing " + remaining + " to fullfill input request");
        }
        return Collections.unmodifiableList(usedInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsableBalance() {
        AccountBalanceCache accountBalanceCache = this.cache;
        synchronized (accountBalanceCache) {
            long balance = this.cache.getStream().filter(entry -> this.isUsable((Input)entry.getKey(), (DepositRequest)entry.getValue())).map(Map.Entry::getKey).mapToLong(Input::getBalance).sum();
            return balance;
        }
    }

    boolean isUsable(Input input, DepositRequest request) {
        if (!request.hasTimeOut()) {
            if (input.getBalance() == 0L) {
                throw new AccountError("remainder address in system without 'expected amount'");
            }
            return true;
        }
        if (this.clock.time().after(request.getTimeOut())) {
            return true;
        }
        return request.hasExpectedAmount() && input.getBalance() >= request.getExpectedAmount();
    }

    @Override
    public String name() {
        return "InputSelection:default";
    }
}

