/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.builder;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.iota.jota.IotaAPICore;
import org.iota.jota.IotaPoW;
import org.iota.jota.builder.AbstractBuilder;
import org.iota.jota.config.options.ApiConfig;
import org.iota.jota.config.options.ApiSettings;
import org.iota.jota.config.types.IotaDefaultConfig;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.HttpConnector;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiBuilder<T extends ApiBuilder<T, E>, E extends IotaAPICore>
extends AbstractBuilder<T, E, ApiConfig>
implements ApiSettings {
    private static final Logger log = LoggerFactory.getLogger(ApiBuilder.class);
    List<Connection> nodes = new ArrayList<Connection>();
    String protocol;
    String host;
    int port;
    int timeout = 0;
    IotaPoW localPoW;
    ICurl customCurl = SpongeFactory.create(SpongeFactory.Mode.KERL);

    public ApiBuilder() {
        super(log);
    }

    @Override
    protected T generate() throws Exception {
        for (ApiConfig config : this.getConfigs()) {
            if (config == null) continue;
            if (!(config instanceof IotaDefaultConfig) || this.hasLegacyOptions()) {
                if (null == this.protocol) {
                    this.protocol = config.getLegacyProtocol();
                }
                if (null == this.host) {
                    this.host = config.getLegacyHost();
                }
                if (0 == this.port) {
                    this.port = config.getLegacyPort();
                }
            }
            if (0 == this.timeout) {
                this.timeout = config.getConnectionTimeout();
            }
            if (!config.hasNodes() || config instanceof IotaDefaultConfig && this.hasLegacyOptions()) continue;
            for (Connection c : config.getNodes()) {
                this.nodes.add(c);
            }
        }
        if (this.hasLegacyOptions()) {
            this.nodes.add(new HttpConnector(this.protocol, this.host, this.port, this.timeout));
        }
        return (T)this;
    }

    private boolean hasLegacyOptions() {
        return null != this.host || null != this.protocol || 0 != this.port;
    }

    public T withCustomCurl(ICurl curl) {
        this.customCurl = curl;
        return (T)this;
    }

    public T host(String host) {
        try {
            InetAddress.getByName(host);
            this.host = host;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return (T)this;
    }

    public T port(int port) {
        this.port = port;
        return (T)this;
    }

    public T protocol(String protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    public T localPoW(IotaPoW localPoW) {
        this.localPoW = localPoW;
        return (T)this;
    }

    public T timeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public IotaPoW getLocalPoW() {
        return this.localPoW;
    }

    @Override
    public ICurl getCustomCurl() {
        return this.customCurl;
    }

    public T addNode(Connection c) {
        this.nodes.add(c);
        return (T)this;
    }

    @Override
    public List<Connection> getNodes() {
        return this.nodes;
    }

    @Override
    public int getConnectionTimeout() {
        return this.timeout;
    }

    @Override
    public boolean hasNodes() {
        return this.nodes != null && this.nodes.size() > 0;
    }

    @Override
    public int getLegacyPort() {
        return this.getPort();
    }

    @Override
    public String getLegacyProtocol() {
        return this.getProtocol();
    }

    @Override
    public String getLegacyHost() {
        return this.getHost();
    }
}

