/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.iota.jota.config.IotaConfig;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.ConnectionFactory;
import org.iota.jota.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IotaClientConfig
implements IotaConfig {
    private static final Logger log = LoggerFactory.getLogger(IotaClientConfig.class);
    protected Store store;

    protected IotaClientConfig() {
    }

    public IotaClientConfig(Store store) throws Exception {
        this.store = store;
        this.store.load();
    }

    public List<Connection> loadNodes(String key) {
        HashMap<String, String> options;
        int start = 1;
        LinkedList<Connection> connections = new LinkedList<Connection>();
        do {
            options = new HashMap<String, String>();
            String optionKey = key + start;
            for (Map.Entry<String, Serializable> entry : this.store.getAll().entrySet()) {
                if (!entry.getKey().startsWith(optionKey)) continue;
                options.put(entry.getKey().substring(key.length() + 1 + (int)(Math.log10(start) + 1.0)), entry.getValue().toString());
            }
            if (options.size() > 0) {
                try {
                    Connection c = ConnectionFactory.createConnection(options, this.getConnectionTimeout());
                    if (c != null) {
                        connections.add(c);
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
            ++start;
        } while (options.size() > 0);
        return connections;
    }

    @Override
    public boolean hasNodes() {
        List<Connection> nodes = this.getNodes();
        return nodes != null && nodes.size() > 0;
    }

    protected String stringOrNull(String key) {
        Serializable ret = this.store.get(key);
        return ret != null ? ret.toString() : null;
    }

    protected int intOrNull(String key) {
        Serializable ret = this.store.get(key);
        try {
            return Integer.parseInt(ret.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String toString() {
        return this.store.toString();
    }
}

