/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.pow;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Pair;

public class JCurl
implements ICurl {
    public static final int HASH_LENGTH = 243;
    private static final int STATE_LENGTH = 729;
    public static final int NUMBER_OF_ROUNDSP81 = 81;
    public static final int NUMBER_OF_ROUNDSP27 = 27;
    private final int numberOfRounds;
    private static final int[] TRUTH_TABLE = new int[]{1, 0, -1, 2, 1, -1, 0, 2, -1, 1, 0};
    private final long[] stateLow;
    private final long[] stateHigh;
    private final int[] scratchpad = new int[729];
    private int[] state;

    public JCurl(boolean pair, SpongeFactory.Mode mode) {
        switch (mode) {
            case CURLP27: {
                this.numberOfRounds = 27;
                break;
            }
            case CURLP81: {
                this.numberOfRounds = 81;
                break;
            }
            default: {
                throw new NoSuchElementException("Only Curl-P-27 and Curl-P-81 are supported.");
            }
        }
        if (pair) {
            this.stateHigh = new long[729];
            this.stateLow = new long[729];
            this.state = null;
            this.set();
        } else {
            this.state = new int[729];
            this.stateHigh = null;
            this.stateLow = null;
        }
    }

    public JCurl(SpongeFactory.Mode mode) {
        switch (mode) {
            case CURLP27: {
                this.numberOfRounds = 27;
                break;
            }
            case CURLP81: {
                this.numberOfRounds = 81;
                break;
            }
            default: {
                throw new NoSuchElementException("Only Curl-P-27 and Curl-P-81 are supported.");
            }
        }
        this.state = new int[729];
        this.stateHigh = null;
        this.stateLow = null;
    }

    @Override
    public JCurl absorb(int[] trits, int offset, int length) {
        do {
            System.arraycopy(trits, offset, this.state, 0, length < 243 ? length : 243);
            this.transform();
            offset += 243;
        } while ((length -= 243) > 0);
        return this;
    }

    @Override
    public JCurl absorb(int[] trits) {
        return this.absorb(trits, 0, trits.length);
    }

    @Override
    public JCurl transform() {
        int scratchpadIndex = 0;
        int prevScratchpadIndex = 0;
        for (int round = 0; round < this.numberOfRounds; ++round) {
            System.arraycopy(this.state, 0, this.scratchpad, 0, 729);
            for (int stateIndex = 0; stateIndex < 729; ++stateIndex) {
                prevScratchpadIndex = scratchpadIndex;
                scratchpadIndex = scratchpadIndex < 365 ? (scratchpadIndex += 364) : (scratchpadIndex -= 365);
                this.state[stateIndex] = TRUTH_TABLE[this.scratchpad[prevScratchpadIndex] + (this.scratchpad[scratchpadIndex] << 2) + 5];
            }
        }
        return this;
    }

    @Override
    public JCurl reset() {
        Arrays.fill(this.state, 0);
        return this;
    }

    public JCurl reset(boolean pair) {
        if (pair) {
            this.set();
        } else {
            this.reset();
        }
        return this;
    }

    @Override
    public int[] squeeze(int[] trits, int offset, int length) {
        do {
            System.arraycopy(this.state, 0, trits, offset, length < 243 ? length : 243);
            this.transform();
            offset += 243;
        } while ((length -= 243) > 0);
        return this.state;
    }

    @Override
    public int[] squeeze(int[] trits) {
        return this.squeeze(trits, 0, trits.length);
    }

    @Override
    public int[] getState() {
        return this.state;
    }

    @Override
    public void setState(int[] state) {
        this.state = state;
    }

    private void set() {
        Arrays.fill(this.stateLow, -1L);
        Arrays.fill(this.stateHigh, -1L);
    }

    private void pairTransform() {
        long[] curlScratchpadLow = new long[729];
        long[] curlScratchpadHigh = new long[729];
        int curlScratchpadIndex = 0;
        int round = this.numberOfRounds;
        while (round-- > 0) {
            System.arraycopy(this.stateLow, 0, curlScratchpadLow, 0, 729);
            System.arraycopy(this.stateHigh, 0, curlScratchpadHigh, 0, 729);
            for (int curlStateIndex = 0; curlStateIndex < 729; ++curlStateIndex) {
                long alpha = curlScratchpadLow[curlScratchpadIndex];
                long beta = curlScratchpadHigh[curlScratchpadIndex];
                long gamma = curlScratchpadHigh[curlScratchpadIndex += curlScratchpadIndex < 365 ? 364 : -365];
                long delta = (alpha | gamma ^ 0xFFFFFFFFFFFFFFFFL) & (curlScratchpadLow[curlScratchpadIndex] ^ beta);
                this.stateLow[curlStateIndex] = delta ^ 0xFFFFFFFFFFFFFFFFL;
                this.stateHigh[curlStateIndex] = alpha ^ gamma | delta;
            }
        }
    }

    public void absorb(Pair<long[], long[]> pair, int offset, int length) {
        int o = offset;
        int l = length;
        do {
            System.arraycopy(pair.low, o, this.stateLow, 0, l < 243 ? l : 243);
            System.arraycopy(pair.hi, o, this.stateHigh, 0, l < 243 ? l : 243);
            this.pairTransform();
            o += 243;
        } while ((l -= 243) > 0);
    }

    public Pair<long[], long[]> squeeze(Pair<long[], long[]> pair, int offset, int length) {
        int o = offset;
        int l = length;
        long[] low = (long[])pair.low;
        long[] hi = (long[])pair.hi;
        do {
            System.arraycopy(this.stateLow, 0, low, o, l < 243 ? l : 243);
            System.arraycopy(this.stateHigh, 0, hi, o, l < 243 ? l : 243);
            this.pairTransform();
            o += 243;
        } while ((l -= 243) > 0);
        return new Pair<long[], long[]>(low, hi);
    }

    @Override
    public ICurl clone() {
        return new JCurl(SpongeFactory.Mode.CURLP81);
    }
}

