/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trits;

public class PendingTransfer
implements Serializable {
    private static final long serialVersionUID = 5549430894683695596L;
    List<Trits> bundleTrits;
    List<Hash> tailHashes;

    private PendingTransfer() {
    }

    public PendingTransfer(List<Trits> bundle) {
        this.bundleTrits = bundle;
    }

    public void addTail(Hash tailHash) {
        if (this.tailHashes == null) {
            this.tailHashes = new ArrayList<Hash>();
        }
        this.tailHashes.add(tailHash);
    }

    public List<Hash> getTailHashes() {
        return this.tailHashes;
    }

    public List<Trits> getBundleTrits() {
        return this.bundleTrits;
    }

    public PendingTransfer clone() throws CloneNotSupportedException {
        return (PendingTransfer)super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleTrits == null ? 0 : this.bundleTrits.hashCode());
        result = 31 * result + (this.tailHashes == null ? 0 : this.tailHashes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PendingTransfer other = (PendingTransfer)obj;
        if (this.bundleTrits == null ? other.bundleTrits != null : !this.bundleTrits.equals(other.bundleTrits)) {
            return false;
        }
        return !(this.tailHashes == null ? other.tailHashes != null : !this.tailHashes.equals(other.tailHashes));
    }

    public String toString() {
        return "PendingTransfer [bundleTrits=" + this.bundleTrits + ", tailHashes=" + this.tailHashes + "]";
    }
}

