/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.addressgenerator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iota.jota.account.AccountOptions;
import org.iota.jota.account.addressgenerator.AddressGeneratorService;
import org.iota.jota.account.errors.AddressGenerationError;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.types.Address;
import org.iota.jota.types.Hash;
import org.iota.jota.utils.IotaAPIUtils;

public class AddressGeneratorServiceImpl
implements AddressGeneratorService {
    private Map<IndexSec, Hash> map;
    private AccountOptions options;

    public AddressGeneratorServiceImpl(AccountOptions options) {
        this(options, true);
    }

    public AddressGeneratorServiceImpl(AccountOptions options, boolean cache) {
        this.options = options;
        if (cache) {
            this.map = new ConcurrentHashMap<IndexSec, Hash>();
        }
    }

    @Override
    public Address get(int index) throws AddressGenerationError {
        return this.get(index, this.options.getSecurityLevel());
    }

    @Override
    public Address get(int index, int securityLevel) throws AddressGenerationError {
        try {
            Hash hash = null;
            boolean add = false;
            if (null != this.map) {
                hash = this.map.get(new IndexSec(index, securityLevel));
                boolean bl = add = hash == null;
            }
            if (null == hash) {
                hash = new Hash(IotaAPIUtils.newAddress(this.options.getSeed().getSeed().getTrytesString(), securityLevel, index, false, this.options.getApi().getCurl()));
            }
            if (add) {
                this.map.put(new IndexSec(index, securityLevel), hash);
            }
            return new Address(hash, index, securityLevel);
        }
        catch (ArgumentException e) {
            throw new AddressGenerationError(e);
        }
    }

    @Override
    public int getSecurityLevel() {
        return this.options.getSecurityLevel();
    }

    private class IndexSec {
        public final int index;
        public final int security;

        IndexSec(int index, int security) {
            this.index = index;
            this.security = security;
        }

        public int hashCode() {
            return this.index ^ this.security;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof IndexSec)) return false;
            IndexSec that = (IndexSec)o;
            if (that.index != this.index) return false;
            if (that.security != this.security) return false;
            return true;
        }
    }
}

