/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.deposits.methods;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.glxn.qrgen.javase.QRCode;
import org.bouncycastle.util.encoders.Base64;
import org.iota.jota.account.deposits.ConditionalDepositAddress;
import org.iota.jota.account.deposits.methods.DepositMethod;

public class QRMethod
implements DepositMethod<QRCode> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public QRMethod() {
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionalDepositAddress parse(QRCode method) {
        String conditions;
        ByteArrayOutputStream baos = method.stream();
        try {
            conditions = QRMethod.readQRCode(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (NotFoundException | IOException e) {
            e.printStackTrace();
            ConditionalDepositAddress conditionalDepositAddress = null;
            return conditionalDepositAddress;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ConditionalDepositAddress depositConditions = this.loadFromInputStream(Base64.decode((String)conditions));
        return depositConditions;
    }

    public static String readQRCode(InputStream stream) throws IOException, NotFoundException {
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(ImageIO.read(stream))));
        Result qrCodeResult = new MultiFormatReader().decode(binaryBitmap);
        return qrCodeResult.getText();
    }

    @Override
    public QRCode build(ConditionalDepositAddress conditions) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            this.writeToOutputStream(bo, conditions);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return QRCode.from((String)new String(Base64.encode((byte[])bo.toByteArray())));
    }

    protected ConditionalDepositAddress loadFromInputStream(byte[] stream) {
        ConditionalDepositAddress conditions;
        try {
            conditions = (ConditionalDepositAddress)this.objectMapper.readValue(stream, (TypeReference)new TypeReference<ConditionalDepositAddress>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return conditions;
    }

    protected void writeToOutputStream(OutputStream stream, ConditionalDepositAddress store) throws IOException {
        this.objectMapper.writeValue(stream, (Object)store);
    }
}

