/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.event.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.iota.jota.account.event.AccountEvent;
import org.iota.jota.account.event.Event;
import org.iota.jota.account.event.EventListener;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.utils.Pair;

public class EventManagerImpl
implements EventManager {
    private Map<Class<? extends Event>, List<Pair<EventListener, Method>>> listeners = new ConcurrentHashMap<Class<? extends Event>, List<Pair<EventListener, Method>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Event event) {
        List<Pair<EventListener, Method>> listeners = this.getListeners(event.getClass());
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        List<Pair<EventListener, Method>> list = listeners;
        synchronized (list) {
            for (Pair<EventListener, Method> listener : listeners) {
                try {
                    boolean accessible = listener.getHi().isAccessible();
                    if (!accessible) {
                        listener.getHi().setAccessible(true);
                    }
                    listener.getHi().invoke((Object)listener.getLow(), event);
                    if (accessible) continue;
                    listener.getHi().setAccessible(false);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<Pair<EventListener, Method>> getListeners(Class<? extends Event> c) {
        return this.listeners.get(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(EventListener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Parameter param;
            if (!method.isAnnotationPresent(AccountEvent.class) || method.getParameterCount() != 1 || !Event.class.isAssignableFrom((param = method.getParameters()[0]).getType())) continue;
            Map<Class<? extends Event>, List<Pair<EventListener, Method>>> map = this.listeners;
            synchronized (map) {
                List<Pair<EventListener, Method>> listeners = this.listeners.get(param.getType());
                if (listeners == null) {
                    listeners = Collections.synchronizedList(new ArrayList());
                    this.listeners.put(param.getType(), listeners);
                }
                listeners.add(new Pair<EventListener, Method>(listener, method));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterListener(EventListener listener) {
        Set<Map.Entry<Class<? extends Event>, List<Pair<EventListener, Method>>>> lists = this.listeners.entrySet();
        Iterator<Map.Entry<Class<? extends Event>, List<Pair<EventListener, Method>>>> listIterator = lists.iterator();
        while (listIterator.hasNext()) {
            List<Pair<EventListener, Method>> pairs;
            Map.Entry<Class<? extends Event>, List<Pair<EventListener, Method>>> entry = listIterator.next();
            List<Pair<EventListener, Method>> list = pairs = entry.getValue();
            synchronized (list) {
                int size = pairs.size();
                Iterator<Pair<EventListener, Method>> pairIterator = pairs.iterator();
                while (pairIterator.hasNext()) {
                    Pair<EventListener, Method> pair = pairIterator.next();
                    if (!pair.getLow().equals(listener)) continue;
                    pairIterator.remove();
                    --size;
                }
                if (size == 0) {
                    listIterator.remove();
                }
            }
        }
    }
}

