/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.plugins.promoter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.AccountOptions;
import org.iota.jota.account.AccountStateManager;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.event.AccountEvent;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.account.event.events.EventPromotion;
import org.iota.jota.account.event.events.EventReattachment;
import org.iota.jota.account.event.events.EventSentTransfer;
import org.iota.jota.account.event.events.EventTransferConfirmed;
import org.iota.jota.account.plugins.AccountPlugin;
import org.iota.jota.account.plugins.promoter.PromoterReattacher;
import org.iota.jota.dto.response.GetTrytesResponse;
import org.iota.jota.dto.response.ReplayBundleResponse;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Transaction;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trits;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.thread.UnboundScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromoterReattacherImpl
extends AccountPlugin
implements PromoterReattacher {
    private static final Logger log = LoggerFactory.getLogger(PromoterReattacherImpl.class);
    private static final int APROX_ABOVE_MAX_DEPTH_MIN = 5;
    private static final long PROMOTE_DELAY = 10000L;
    private EventManager eventManager;
    private IotaAPI api;
    private AccountStateManager manager;
    private AccountOptions options;
    private UnboundScheduledExecutorService service;
    private Map<String, ScheduledFuture<?>> unconfirmedBundles;
    private Map<String, List<Transaction>> bundleTails;

    public PromoterReattacherImpl(EventManager eventManager, IotaAPI api, AccountStateManager manager, AccountOptions options) {
        this.eventManager = eventManager;
        this.api = api;
        this.manager = manager;
        this.options = options;
    }

    @Override
    public void load() {
        this.unconfirmedBundles = new ConcurrentHashMap();
        this.bundleTails = new ConcurrentHashMap<String, List<Transaction>>();
        this.service = new UnboundScheduledExecutorService();
        for (Map.Entry<String, PendingTransfer> entry : this.manager.getPendingTransfers().entrySet()) {
            Bundle bundle = new Bundle();
            for (Trits trits : entry.getValue().getBundleTrits()) {
                Transaction tx = new Transaction(Converter.trytes(trits.getTrits()));
                bundle.addTransaction(tx);
            }
            bundle.setLength(entry.getValue().getBundleTrits().size());
            this.addUnconfirmedBundle(bundle, 0L);
        }
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void shutdown() {
        this.service.shutdownNow();
    }

    @AccountEvent
    private void onBundleBroadcast(EventSentTransfer event) {
        this.addUnconfirmedBundle(event.getBundle(), 10000L);
    }

    private void addUnconfirmedBundle(Bundle bundle, long initialDelay) {
        this.addBundleTail(bundle.getTransactions().get(0).getHash(), bundle.getTransactions().get(0));
        Runnable r = () -> this.doTask(bundle);
        this.unconfirmedBundles.put(bundle.getBundleHash(), this.service.scheduleAtFixedRate(r, initialDelay, 10000L, TimeUnit.MILLISECONDS));
    }

    @AccountEvent
    private void onConfirmed(EventTransferConfirmed event) {
        String tail = this.getOriginalTailFromBundle(event.getBundle());
        List<Transaction> allTails = this.bundleTails.get(tail);
        for (Transaction tx : allTails) {
            ScheduledFuture<?> runnable = this.unconfirmedBundles.remove(tx.getBundle());
            if (null == runnable || runnable.isDone()) continue;
            runnable.cancel(true);
        }
        this.bundleTails.remove(tail);
    }

    private String getOriginalTailFromBundle(Bundle bundle) {
        String tail = bundle.getTransactions().get(0).getHash();
        for (Map.Entry<String, List<Transaction>> entry : this.bundleTails.entrySet()) {
            if (entry.getKey().equals(tail)) {
                return entry.getKey();
            }
            for (Transaction tx : entry.getValue()) {
                if (!tx.getBundle().equals(bundle.getBundleHash())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void doTask(Bundle bundle) {
        try {
            PendingTransfer pendingBundle = this.getPendingTransferForBundle(bundle);
            if (null == pendingBundle) {
                return;
            }
            String promotableTail = this.findPromotableTail(pendingBundle);
            if (promotableTail != null) {
                this.promote(bundle, promotableTail);
            } else {
                this.reattach(bundle);
            }
        }
        catch (Exception e) {
            log.error("Failed to run promote task for " + bundle.getBundleHash() + ": " + e.getMessage());
        }
    }

    private PendingTransfer getPendingTransferForBundle(Bundle bundle) {
        String hash = bundle.getTransactions().get(0).getHash();
        for (Map.Entry<String, PendingTransfer> entry : this.manager.getPendingTransfers().entrySet()) {
            if (!entry.getKey().equals(hash)) continue;
            return entry.getValue();
        }
        return null;
    }

    private String findPromotableTail(PendingTransfer pendingBundle) {
        String tailOrig = pendingBundle.getTailHashes().get(0).getHash();
        for (int i = pendingBundle.getTailHashes().size() - 1; i >= 0; --i) {
            String tail = pendingBundle.getTailHashes().get(i).getHash();
            Transaction tailTransaction = this.getBundleTail(tailOrig, tail);
            if (null == tailTransaction) {
                GetTrytesResponse res = this.api.getTrytes(tail);
                if (res.getTrytes().length < 1) continue;
                tailTransaction = new Transaction(res.getTrytes()[0]);
                this.addBundleTail(tailOrig, tailTransaction);
            }
            if (this.aboveMaxDepth(tailTransaction.getAttachmentTimestamp())) continue;
            return tail;
        }
        return null;
    }

    private void addBundleTail(String bundleHash, Transaction tailTransaction) {
        List<Transaction> tails = this.bundleTails.get(bundleHash);
        if (null == tails) {
            tails = new ArrayList<Transaction>();
            this.bundleTails.put(bundleHash, tails);
        }
        tails.add(tailTransaction);
    }

    private Transaction getBundleTail(String originalTail, String tail) {
        List<Transaction> tails = this.bundleTails.get(originalTail);
        if (null != tails) {
            for (Transaction t : tails) {
                if (!t.getHash().equals(tail)) continue;
                return t;
            }
        }
        return null;
    }

    private boolean aboveMaxDepth(long time) {
        Date now = this.options.getTime().time();
        long res = now.getTime() - time;
        return TimeUnit.MINUTES.convert(res, TimeUnit.MILLISECONDS) > 5L;
    }

    private void promote(Bundle pendingBundle) {
        this.promote(pendingBundle, pendingBundle.getTransactions().get(0).getHash());
    }

    @Override
    public void promote(Bundle pendingBundle, String promotableTail) {
        List<Transaction> res = this.api.promoteTransaction(promotableTail, this.options.getDepth(), this.options.getMwm(), pendingBundle);
        Collections.reverse(res);
        Bundle promotedBundle = new Bundle(res);
        EventPromotion event = new EventPromotion(promotedBundle);
        this.eventManager.emit(event);
    }

    @Override
    public void reattach(Bundle pendingBundle) {
        Bundle newBundle = this.createReattachBundle(pendingBundle);
        Collections.reverse(newBundle.getTransactions());
        this.manager.addTailHash(new Hash(pendingBundle.getTransactions().get(0).getHash()), new Hash(newBundle.getTransactions().get(0).getHash()));
        EventReattachment event = new EventReattachment(pendingBundle, newBundle);
        this.eventManager.emit(event);
        this.promote(newBundle);
    }

    private Bundle createReattachBundle(Bundle pendingBundle) {
        ReplayBundleResponse ret = this.api.replayBundle(pendingBundle, this.options.getDepth(), this.options.getMwm(), null);
        return ret.getNewBundle();
    }

    @Override
    public String name() {
        return "promoter-reattacher";
    }
}

