/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.store;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.iota.jota.account.AccountState;
import org.iota.jota.account.ExportedAccountState;
import org.iota.jota.account.PendingTransfer;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.store.AccountStoreImpl;
import org.iota.jota.store.IotaFileStore;
import org.iota.jota.store.JsonFlatFileStore;
import org.iota.jota.store.Store;
import org.iota.jota.types.Hash;
import org.iota.jota.types.Trytes;

public class AccountFileStore
extends AccountStoreImpl {
    private Store store;

    public AccountFileStore() {
        this.store = new IotaFileStore();
    }

    public AccountFileStore(File file) {
        this.store = new JsonFlatFileStore(file);
    }

    public AccountFileStore(Store fileStore) {
        this.store = fileStore;
    }

    public AccountFileStore(String file) {
        this.store = new IotaFileStore(file);
    }

    @Override
    public void load() throws Exception {
        this.store.load();
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void shutdown() {
        try {
            this.store.save(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public AccountState loadAccount(String id) {
        AccountState state = this.store.get(id, null);
        if (state == null) {
            state = new AccountState();
            this.saveAccount(id, state);
        }
        return state;
    }

    @Override
    public void saveAccount(String id, AccountState state) {
        this.store.set(id, state);
        this.save();
    }

    @Override
    public void removeAccount(String id) {
        this.store.delete(id);
        this.save();
    }

    @Override
    public int readIndex(String id) {
        return this.loadAccount(id).getKeyIndex();
    }

    @Override
    public void writeIndex(String id, int index) {
        this.loadAccount(id).setKeyIndex(index);
        this.save();
    }

    @Override
    public void addDepositAddress(String id, int index, StoredDepositAddress request) {
        this.loadAccount(id).addDepositRequest(index, request);
        this.save();
    }

    @Override
    public void removeDepositAddress(String id, int index) {
        this.loadAccount(id).removeDepositRequest(index);
        this.save();
    }

    @Override
    public Map<Integer, StoredDepositAddress> getDepositAddresses(String id) {
        return this.loadAccount(id).getDepositRequests();
    }

    @Override
    public void addPendingTransfer(String id, Hash tailTx, Trytes[] bundleTrytes, int ... indices) {
        PendingTransfer pendingTransfer = new PendingTransfer(this.trytesToTrits(bundleTrytes));
        pendingTransfer.addTail(tailTx);
        this.loadAccount(id).addPendingTransfers(tailTx.getHash(), pendingTransfer);
        this.save();
    }

    @Override
    public void removePendingTransfer(String id, Hash tailHash) {
        this.loadAccount(id).removePendingTransfer(tailHash.getHash());
        this.save();
    }

    @Override
    public void addTailHash(String id, Hash tailHash, Hash newTailTxHash) {
        this.loadAccount(id).getPendingTransfer(tailHash.getHash()).addTail(newTailTxHash);
        this.save();
    }

    @Override
    public Map<String, PendingTransfer> getPendingTransfers(String id) {
        return this.loadAccount(id).getPendingTransfers();
    }

    @Override
    public void importAccount(ExportedAccountState state) {
        this.saveAccount(state.getId(), state.getState());
    }

    @Override
    public ExportedAccountState exportAccount(String id) {
        AccountState state = this.loadAccount(id);
        return new ExportedAccountState(new Date(), id, state);
    }

    private void save() {
        try {
            this.store.save(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.store.toString();
    }
}

