/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.builder;

import java.util.ArrayList;
import java.util.List;
import org.iota.jota.IotaAPI;
import org.iota.jota.IotaAccount;
import org.iota.jota.account.AccountOptions;
import org.iota.jota.account.AccountStore;
import org.iota.jota.account.clock.Clock;
import org.iota.jota.account.clock.SystemClock;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.account.plugins.Plugin;
import org.iota.jota.account.seedprovider.SeedProvider;
import org.iota.jota.account.seedprovider.SeedProviderImpl;
import org.iota.jota.builder.AbstractBuilder;
import org.iota.jota.config.options.AccountConfig;
import org.iota.jota.config.options.AccountSettings;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.utils.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountBuilder
extends AbstractBuilder<AccountBuilder, IotaAccount, AccountConfig>
implements AccountSettings {
    private static final Logger log = LoggerFactory.getLogger(AccountBuilder.class);
    private AccountStore store;
    private IotaAPI api;
    private SeedProvider seed;
    private int mwm;
    private int depth;
    private int securityLevel;
    private Clock clock;
    private List<Plugin> plugins;

    public AccountBuilder(String seed) throws ArgumentException {
        super(log);
        if (!InputValidator.isValidSeed(seed)) {
            throw new ArgumentException("Invalid seed provided.");
        }
        this.seed = new SeedProviderImpl(seed);
    }

    public AccountBuilder(SeedProvider seed) {
        super(log);
        this.seed = seed;
    }

    public AccountBuilder mwm(int mwm) {
        if (mwm > 0) {
            this.mwm = mwm;
        } else {
            log.warn("Invalid input provided.");
        }
        return this;
    }

    public AccountBuilder depth(int depth) {
        if (depth > 0) {
            this.depth = depth;
        } else {
            log.warn("Invalid input provided.");
        }
        return this;
    }

    public AccountBuilder securityLevel(int securityLevel) {
        if (InputValidator.isValidSecurityLevel(securityLevel)) {
            this.securityLevel = securityLevel;
        } else {
            log.warn("Invalid security level provided.");
        }
        return this;
    }

    public AccountBuilder store(AccountStore store) {
        if (null == store) {
            throw new AccountError("Cannot set store to null");
        }
        this.store = store;
        return this;
    }

    public AccountBuilder api(IotaAPI api) {
        if (null == api) {
            throw new AccountError("Cannot set api to null");
        }
        this.api = api;
        return this;
    }

    public AccountBuilder clock(Clock clock) {
        if (null == clock) {
            throw new AccountError("Cannot set clock to null");
        }
        this.clock = clock;
        return this;
    }

    public AccountBuilder plugin(Plugin plugin) {
        if (null != plugin) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<Plugin>();
            }
        } else {
            throw new AccountError("Attempted to add null as a plugin");
        }
        this.plugins.add(plugin);
        return this;
    }

    @Override
    public AccountBuilder generate() throws Exception {
        for (AccountConfig config : this.getConfigs()) {
            if (config == null) continue;
            if (0 == this.getMwm() && config.getMwm() != 0) {
                this.mwm(config.getMwm());
            }
            if (0 == this.getDepth() && config.getDepth() != 0) {
                this.depth(config.getDepth());
            }
            if (0 == this.getSecurityLevel() && config.getSecurityLevel() != 0) {
                this.securityLevel(config.getSecurityLevel());
            }
            if (null == this.store && config.getStore() != null) {
                this.store(config.getStore());
            }
            if (null == this.api) {
                this.api((IotaAPI)new IotaAPI.Builder().build());
            }
            if (null != this.clock) continue;
            this.clock(new SystemClock());
        }
        return this;
    }

    @Override
    protected IotaAccount compile() {
        return new IotaAccount(new AccountOptions(this));
    }

    @Override
    public SeedProvider getSeed() {
        return this.seed;
    }

    @Override
    public IotaAPI getApi() {
        return this.api;
    }

    @Override
    public int getMwm() {
        return this.mwm;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public AccountStore getStore() {
        return this.store;
    }

    @Override
    public Clock getTime() {
        return this.clock;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.plugins;
    }
}

