/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.builder;

import org.iota.jota.utils.InputValidator;

public class AddressRequest {
    private final String seed;
    private final int securityLevel;
    private final int index;
    private final boolean checksum;
    private final int amount;
    private final boolean addSpendAddresses;

    private AddressRequest(Builder builder) {
        this.seed = builder.seed;
        this.securityLevel = builder.securityLevel;
        this.amount = builder.amount;
        this.index = builder.index;
        this.checksum = builder.checksum;
        this.addSpendAddresses = builder.addSpendAddresses;
    }

    public String getSeed() {
        return this.seed;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isAddSpendAddresses() {
        return this.addSpendAddresses;
    }

    public String toString() {
        return "AddressRequest{seed='" + this.seed + '\'' + ", securityLevel=" + this.securityLevel + ", index=" + this.index + ", checksum=" + this.checksum + ", amount=" + this.amount + ", addSpendAddresses=" + this.addSpendAddresses + '}';
    }

    public static class Builder {
        private final String seed;
        private final int securityLevel;
        private int amount = 0;
        private int index = 0;
        private boolean checksum = false;
        private boolean addSpendAddresses = false;

        public Builder(String seed, int securityLevel) {
            this.seed = InputValidator.requireValidSeed(seed);
            this.securityLevel = InputValidator.requireValidSecurityLevel(securityLevel);
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder index(int index) {
            this.index = index;
            return this;
        }

        public Builder checksum(boolean checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder addSpendAddresses(boolean addSpendAddresses) {
            this.addSpendAddresses = addSpendAddresses;
            return this;
        }

        public AddressRequest build() {
            return new AddressRequest(this);
        }
    }
}

