/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.store;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.iota.jota.account.AccountState;
import org.iota.jota.store.FlatFileStore;

public class JsonFlatFileStore
extends FlatFileStore {
    private ObjectMapper objectMapper;

    public JsonFlatFileStore(File file) {
        super(file);
        this.loadJson();
    }

    public JsonFlatFileStore(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
        this.loadJson();
    }

    public JsonFlatFileStore(String location) {
        super(location);
        this.loadJson();
    }

    private void loadJson() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    protected Map<String, Serializable> loadFromInputStream(InputStream stream) {
        try {
            return Collections.unmodifiableMap((Map)this.objectMapper.readValue(stream, (TypeReference)new TypeReference<Map<String, AccountState>>(){}));
        }
        catch (IOException e) {
            if (e.getClass().equals(MismatchedInputException.class)) {
                return new HashMap<String, Serializable>();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void writeToOutputStream(OutputStream stream, Map<String, Serializable> store) throws IOException {
        this.objectMapper.writeValue(stream, store);
    }
}

