/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils.thread;

import java.util.HashMap;
import java.util.Map;
import org.iota.jota.utils.thread.ThreadIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);
    private static final Map<Object, Thread> threads = new HashMap<Object, Thread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread spawnThread(Runnable runnable, ThreadIdentifier threadIdentifier) {
        if (threads.get(threadIdentifier) == null || threads.get(threadIdentifier).isInterrupted()) {
            ThreadIdentifier threadIdentifier2 = threadIdentifier;
            synchronized (threadIdentifier2) {
                if (threads.get(threadIdentifier) == null || threads.get(threadIdentifier).isInterrupted()) {
                    threads.put(threadIdentifier, ThreadUtils.spawnThread(runnable, threadIdentifier.getName()));
                }
            }
        }
        return threads.get(threadIdentifier);
    }

    public static Thread spawnThread(Runnable runnable, String threadName) {
        logger.info("Starting Thread: " + threadName + " ...");
        Thread thread = new Thread(() -> {
            logger.info(threadName + " [STARTED]");
            runnable.run();
            logger.info(threadName + " [STOPPED]");
        }, threadName);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread stopThread(ThreadIdentifier threadIdentifier) {
        if (threads.get(threadIdentifier) != null && !threads.get(threadIdentifier).isInterrupted()) {
            ThreadIdentifier threadIdentifier2 = threadIdentifier;
            synchronized (threadIdentifier2) {
                if (threads.get(threadIdentifier) != null && !threads.get(threadIdentifier).isInterrupted()) {
                    logger.info("Stopping Thread: " + threadIdentifier.getName() + " ...");
                    threads.get(threadIdentifier).interrupt();
                }
            }
        }
        return threads.get(threadIdentifier);
    }

    public static boolean sleep(int timeoutInMS) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        try {
            Thread.sleep(timeoutInMS);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

