/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils;

import java.util.Arrays;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Bundle;
import org.iota.jota.pow.ICurl;
import org.iota.jota.pow.SpongeFactory;
import org.iota.jota.utils.Converter;
import org.iota.jota.utils.InputValidator;
import org.iota.jota.utils.Signing;

public class Multisig {
    private ICurl curl;
    private Signing signingInstance;

    public Multisig(ICurl customCurl) {
        this.curl = customCurl;
        this.curl.reset();
        this.signingInstance = new Signing(this.curl.clone());
    }

    public Multisig() {
        this(SpongeFactory.create(SpongeFactory.Mode.KERL));
    }

    public String getDigest(String seed, int security, int index) throws ArgumentException {
        int[] key = this.signingInstance.key(Converter.trits(seed, 243), index, security);
        return Converter.trytes(this.signingInstance.digests(key));
    }

    public String addAddressDigest(String digestTrytes, String curlStateTrytes) {
        int[] digest = Converter.trits(digestTrytes, digestTrytes.length() * 3);
        int[] curlState = !curlStateTrytes.isEmpty() ? Converter.trits(curlStateTrytes, digestTrytes.length() * 3) : new int[digestTrytes.length() * 3];
        this.curl.setState(curlState);
        this.curl.absorb(digest);
        return Converter.trytes(this.curl.getState());
    }

    public String getKey(String seed, int index, int security) throws ArgumentException {
        return Converter.trytes(this.signingInstance.key(Converter.trits(seed, 81 * security), index, security));
    }

    public String finalizeAddress(String curlStateTrytes) {
        int[] curlState = Converter.trits(curlStateTrytes);
        this.curl.setState(curlState);
        int[] addressTrits = new int[243];
        this.curl.squeeze(addressTrits);
        return Converter.trytes(addressTrits);
    }

    public boolean validateAddress(String multisigAddress, int[][] digests) {
        this.curl.reset();
        for (int[] keyDigest : digests) {
            this.curl.absorb(keyDigest);
        }
        int[] addressTrits = new int[243];
        this.curl.squeeze(addressTrits);
        return Converter.trytes(addressTrits).equals(multisigAddress);
    }

    public Bundle addSignature(Bundle bundleToSign, String inputAddress, String keyTrytes) {
        int security = keyTrytes.length() / 2187;
        int[] key = Converter.trits(keyTrytes);
        int numSignedTxs = 0;
        for (int i = 0; i < bundleToSign.getTransactions().size(); ++i) {
            if (!bundleToSign.getTransactions().get(i).getAddress().equals(inputAddress)) continue;
            if (!InputValidator.isNinesTrytes(bundleToSign.getTransactions().get(i).getSignatureFragments(), bundleToSign.getTransactions().get(i).getSignatureFragments().length())) {
                ++numSignedTxs;
                continue;
            }
            String bundleHash = bundleToSign.getTransactions().get(i).getBundle();
            int[] firstFragment = Arrays.copyOfRange(key, 0, 6561);
            int[][] normalizedBundleFragments = new int[3][27];
            int[] normalizedBundleHash = bundleToSign.normalizedBundle(bundleHash);
            for (int k = 0; k < 3; ++k) {
                normalizedBundleFragments[k] = Arrays.copyOfRange(normalizedBundleHash, k * 27, (k + 1) * 27);
            }
            int[] firstBundleFragment = normalizedBundleFragments[numSignedTxs % 3];
            int[] firstSignedFragment = this.signingInstance.signatureFragment(firstBundleFragment, firstFragment);
            bundleToSign.getTransactions().get(i).setSignatureFragments(Converter.trytes(firstSignedFragment));
            for (int j = 1; j < security; ++j) {
                int[] nextFragment = Arrays.copyOfRange(key, 6561 * j, (j + 1) * 6561);
                int[] nextBundleFragment = normalizedBundleFragments[(numSignedTxs + j) % 3];
                int[] nextSignedFragment = this.signingInstance.signatureFragment(nextBundleFragment, nextFragment);
                bundleToSign.getTransactions().get(i + j).setSignatureFragments(Converter.trytes(nextSignedFragment));
            }
            break;
        }
        return bundleToSign;
    }
}

