/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.store;

import java.io.Serializable;
import java.util.Map;
import org.iota.jota.store.Store;

public class EnvironmentStore
implements Store {
    @Override
    public void load() {
    }

    @Override
    public void save(boolean closeResources) throws Exception {
        throw new Exception("Environment store does not allow saving");
    }

    public String get(String key) {
        return System.getenv(key);
    }

    @Override
    public <T extends Serializable> T get(String key, T def) {
        try {
            String value = System.getenv(key);
            return (T)(value != null ? value : def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    @Override
    public <T extends Serializable> T set(String key, T value) {
        throw new IllegalArgumentException("Environment store does not allow setting values");
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    public String toString() {
        return "Environment variables";
    }

    @Override
    public Map<String, Serializable> getAll() {
        return System.getenv();
    }

    public String delete(String key) {
        throw new IllegalArgumentException("Environment store does not allow deleting");
    }
}

