/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils.thread;

import java.util.concurrent.TimeUnit;
import org.iota.jota.utils.thread.BoundedScheduledExecutorService;
import org.iota.jota.utils.thread.ReportingExecutorService;
import org.iota.jota.utils.thread.TaskDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedicatedScheduledExecutorService
extends BoundedScheduledExecutorService
implements ReportingExecutorService {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(DedicatedScheduledExecutorService.class);
    private final Logger logger;
    private final String threadName;
    private final boolean debug;

    public DedicatedScheduledExecutorService(String threadName, Logger logger, boolean debug) {
        super(1);
        this.threadName = threadName;
        this.logger = logger;
        this.debug = debug;
    }

    public DedicatedScheduledExecutorService(String threadName, boolean debug) {
        this(threadName, DEFAULT_LOGGER, debug);
    }

    public DedicatedScheduledExecutorService(String threadName, Logger logger) {
        this(threadName, logger, false);
    }

    public DedicatedScheduledExecutorService(Logger logger, boolean debug) {
        this(null, logger, debug);
    }

    public DedicatedScheduledExecutorService(String threadName) {
        this(threadName, DEFAULT_LOGGER, false);
    }

    public DedicatedScheduledExecutorService(Logger logger) {
        this(null, logger, false);
    }

    public DedicatedScheduledExecutorService(boolean debug) {
        this(null, DEFAULT_LOGGER, debug);
    }

    public DedicatedScheduledExecutorService() {
        this(null, DEFAULT_LOGGER, false);
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public void onScheduleTask(TaskDetails taskDetails) {
        super.onScheduleTask(taskDetails);
        if (this.debug || this.threadName != null) {
            this.printScheduledMessage(taskDetails);
        }
    }

    @Override
    public void onStartTask(TaskDetails taskDetails) {
        super.onStartTask(taskDetails);
        if (this.debug || this.threadName != null && taskDetails.getExecutionCount().get() == 0) {
            Thread.currentThread().setName(taskDetails.getThreadName());
            this.printStartedMessage(taskDetails);
        }
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        } else {
            Thread.currentThread().setName(this.getPrintableThreadName(taskDetails));
        }
    }

    @Override
    public void onFinishTask(TaskDetails taskDetails, Throwable error) {
        super.onFinishTask(taskDetails, error);
        if (this.debug && error == null) {
            Thread.currentThread().setName(taskDetails.getThreadName());
            this.printFinishedMessage(taskDetails);
        }
    }

    @Override
    public void onCancelTask(TaskDetails taskDetails) {
        super.onCancelTask(taskDetails);
        if (this.debug || this.threadName != null) {
            this.printStopMessage(taskDetails);
        }
    }

    @Override
    public void onCompleteTask(TaskDetails taskDetails, Throwable error) {
        super.onCompleteTask(taskDetails, error);
        if (this.debug || this.threadName != null || error != null) {
            String oldThreadName = Thread.currentThread().getName();
            if (oldThreadName.equals(this.getPrintableThreadName(taskDetails))) {
                Thread.currentThread().setName(taskDetails.getThreadName());
            }
            this.printStoppedMessage(taskDetails, error);
            if (!oldThreadName.equals(Thread.currentThread().getName())) {
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    private void printScheduledMessage(TaskDetails taskDetails) {
        this.logger.info(this.buildScheduledMessage(taskDetails));
    }

    private void printStartedMessage(TaskDetails taskDetails) {
        this.logger.info(this.buildStartedMessage(taskDetails));
    }

    private void printFinishedMessage(TaskDetails taskDetails) {
        this.logger.info(this.buildFinishedMessage(taskDetails));
    }

    private void printStopMessage(TaskDetails taskDetails) {
        this.logger.info(this.buildStopMessage(taskDetails));
    }

    private void printStoppedMessage(TaskDetails taskDetails, Throwable error) {
        String stoppedMessage = this.buildStoppedMessage(taskDetails, error);
        if (error != null) {
            this.logger.error(stoppedMessage, error);
        } else {
            this.logger.info(stoppedMessage);
        }
    }

    private String getPrintableThreadName(TaskDetails taskDetails) {
        return this.threadName != null ? this.threadName : "UNNAMED THREAD (started by \"" + taskDetails.getThreadName() + "\")";
    }

    private String buildScheduledMessage(TaskDetails taskDetails) {
        String printableThreadName = this.getPrintableThreadName(taskDetails);
        String timeoutMessageFragment = this.buildDelayMessageFragment(taskDetails);
        String intervalMessageFragment = this.buildIntervalMessageFragment(taskDetails);
        String timeMessageFragment = "";
        if (timeoutMessageFragment != null) {
            timeMessageFragment = timeMessageFragment + " (" + timeoutMessageFragment + (intervalMessageFragment != null ? " / " : ")");
        }
        if (intervalMessageFragment != null) {
            timeMessageFragment = timeMessageFragment + (timeoutMessageFragment == null ? " (" : "") + intervalMessageFragment + ")";
        }
        return "Starting [" + printableThreadName + "]" + timeMessageFragment + " ...";
    }

    private String buildStartedMessage(TaskDetails taskDetails) {
        String printableThreadName = this.getPrintableThreadName(taskDetails);
        return "[" + printableThreadName + "] Started (execution #" + (taskDetails.getExecutionCount().get() + 1) + ") ...";
    }

    private String buildFinishedMessage(TaskDetails taskDetails) {
        String printableThreadName = this.getPrintableThreadName(taskDetails);
        return "[" + printableThreadName + "] Finished (execution #" + taskDetails.getExecutionCount().get() + ") ...";
    }

    private String buildStopMessage(TaskDetails taskDetails) {
        String printableThreadName = this.getPrintableThreadName(taskDetails);
        return taskDetails.getExecutionCount().get() > 0 ? "Stopping [" + printableThreadName + "] ..." : "Cancelling Start [" + printableThreadName + "] ...";
    }

    private String buildStoppedMessage(TaskDetails taskDetails, Throwable error) {
        String printableThreadName = this.getPrintableThreadName(taskDetails);
        if (error != null) {
            return "[" + printableThreadName + "] Crashed (after #" + taskDetails.getExecutionCount().get() + " executions) ...";
        }
        if (taskDetails.getExecutionCount().get() > 0) {
            return "[" + printableThreadName + "] Stopped (after #" + taskDetails.getExecutionCount().get() + " executions) ...";
        }
        return "[" + printableThreadName + "] Cancelled Start ...";
    }

    private String buildDelayMessageFragment(TaskDetails taskDetails) {
        if (taskDetails.getDelay() == null) {
            return null;
        }
        return "starts in " + taskDetails.getDelay() + this.buildUnitAbbreviation(taskDetails.getTimeUnit());
    }

    private String buildIntervalMessageFragment(TaskDetails taskDetails) {
        if (taskDetails.getInterval() == null) {
            return null;
        }
        return "runs every " + taskDetails.getInterval() + this.buildUnitAbbreviation(taskDetails.getTimeUnit());
    }

    private String buildUnitAbbreviation(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hours";
            }
            case DAYS: {
                return "days";
            }
        }
        return "";
    }
}

