/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.gem.AutoGenerateSetting;
import org.iplass.gem.BinaryDownloadLoggingTargetProperty;
import org.iplass.gem.EntityViewHelper;
import org.iplass.gem.ImageColorSetting;
import org.iplass.gem.Skin;
import org.iplass.gem.Theme;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class GemConfigService
implements Service {
    private boolean loadWithReference;
    private boolean formatNumberWithComma;
    private int csvDownloadMaxCount;
    private int uploadableCsvDownloadLoadSize;
    private List<String> csvDownloadCharacterCode;
    private boolean csvDownloadQuoteAll;
    private boolean csvDownloadReferenceVersion;
    private int csvUploadCommitCount;
    private boolean csvUploadAsync;
    private int csvUploadStatusPollingInterval;
    private int searchResultCacheLimit;
    private boolean confirmEditSave;
    private boolean confirmEditCancel;
    @Deprecated
    private boolean topViewEditCancelBackToTop;
    private boolean showSeachCondResetButton;
    private int searchResultDispRowCount;
    private int searchInterval;
    private int csvDownloadInterval;
    private boolean csvDownloadWithFooter;
    private String csvDownloadFooter;
    private boolean showPulldownPleaseSelectLabel;
    private String datePickerDefaultOption;
    private int recycleBinMaxCount;
    private int deleteAllCommandBatchSize;
    private int bulkUpdateAllCommandBatchSize;
    private boolean shallowCopyLobData;
    private List<BinaryDownloadLoggingTargetProperty> binaryDownloadLoggingTargetProperty;
    private List<ImageColorSetting> imageColors;
    private List<Skin> skins;
    private List<Theme> themes;
    private EntityViewHelper entityViewHelper;
    private AutoGenerateSetting autoGenerateSetting;
    private List<String> permitRolesToGem;
    private List<String> permitRolesToNoView;

    public void init(Config config) {
        this.binaryDownloadLoggingTargetProperty = config.getValues("binaryDownloadLoggingTargetProperty", BinaryDownloadLoggingTargetProperty.class);
        this.imageColors = config.getValues("imageColors", ImageColorSetting.class);
        this.loadWithReference = Boolean.valueOf(config.getValue("loadWithReference"));
        this.formatNumberWithComma = Boolean.valueOf(config.getValue("formatNumberWithComma"));
        this.csvDownloadMaxCount = (Integer)config.getValue("csvDownloadMaxCount", Integer.class, (Object)65535);
        this.uploadableCsvDownloadLoadSize = (Integer)config.getValue("uploadableCsvDownloadLoadSize", Integer.class, (Object)1);
        this.csvDownloadCharacterCode = config.getValues("csvDownloadCharacterCode");
        if (this.csvDownloadCharacterCode == null) {
            this.csvDownloadCharacterCode = new ArrayList<String>();
            this.csvDownloadCharacterCode.add("UTF-8");
        }
        this.csvDownloadQuoteAll = config.getValue("csvDownloadQuoteAll") != null ? Boolean.valueOf(config.getValue("csvDownloadQuoteAll")) : true;
        String csvdownloadReferenceVersion = config.getValue("csvDownloadReferenceVersion");
        this.csvDownloadReferenceVersion = csvdownloadReferenceVersion != null ? Boolean.valueOf(csvdownloadReferenceVersion) : true;
        String csvUploadCommitCount = config.getValue("csvUploadCommitCount");
        this.csvUploadCommitCount = csvUploadCommitCount != null ? Integer.parseInt(csvUploadCommitCount) : 1000;
        this.csvUploadAsync = Boolean.valueOf(config.getValue("csvUploadAsync"));
        String csvUploadStatusPollingInterval = config.getValue("csvUploadStatusPollingInterval");
        this.csvUploadStatusPollingInterval = csvUploadStatusPollingInterval != null ? Integer.parseInt(csvUploadStatusPollingInterval) : 10000;
        String searchResultCacheLimit = config.getValue("searchResultCacheLimit");
        this.searchResultCacheLimit = searchResultCacheLimit != null ? Integer.parseInt(searchResultCacheLimit) : 300;
        this.confirmEditSave = Boolean.valueOf(config.getValue("confirmEditSave"));
        this.confirmEditCancel = Boolean.valueOf(config.getValue("confirmEditCancel"));
        this.topViewEditCancelBackToTop = (Boolean)config.getValue("topViewEditCancelBackToTop", Boolean.class, (Object)false);
        this.showSeachCondResetButton = Boolean.valueOf(config.getValue("showSeachCondResetButton"));
        String searchResultDispRowCount = config.getValue("searchResultDispRowCount");
        this.searchResultDispRowCount = searchResultDispRowCount != null ? Integer.parseInt(searchResultDispRowCount) : 10;
        String searchInterval = config.getValue("searchInterval");
        this.searchInterval = searchInterval != null ? Integer.parseInt(searchInterval) : 1000;
        String csvDownloadInterval = config.getValue("csvDownloadInterval");
        this.csvDownloadInterval = csvDownloadInterval != null ? Integer.parseInt(csvDownloadInterval) : 1000;
        this.csvDownloadWithFooter = config.getValue("csvDownloadWithFooter") != null ? Boolean.valueOf(config.getValue("csvDownloadWithFooter")) : false;
        this.csvDownloadFooter = config.getValue("csvDownloadFooter");
        if (this.csvDownloadFooter == null) {
            this.csvDownloadFooter = "";
        }
        this.showPulldownPleaseSelectLabel = config.getValue("showPulldownPleaseSelectLabel") != null ? Boolean.valueOf(config.getValue("showPulldownPleaseSelectLabel")) : true;
        this.datePickerDefaultOption = (String)config.getValue("datePickerDefaultOption", String.class, null);
        this.recycleBinMaxCount = config.getValue("recycleBinMaxCount") != null ? Integer.valueOf(config.getValue("recycleBinMaxCount")) : 100;
        String deleteAllCommandBatchSize = config.getValue("deleteAllCommandBatchSize");
        this.deleteAllCommandBatchSize = deleteAllCommandBatchSize != null ? Integer.parseInt(deleteAllCommandBatchSize) : 100;
        String bulkUpdateAllCommandBatchSize = config.getValue("bulkUpdateAllCommandBatchSize");
        this.bulkUpdateAllCommandBatchSize = bulkUpdateAllCommandBatchSize != null ? Integer.parseInt(bulkUpdateAllCommandBatchSize) : 100;
        this.shallowCopyLobData = config.getValue("shallowCopyLobData") != null ? Boolean.valueOf(config.getValue("shallowCopyLobData")) : false;
        this.skins = config.getValues("skins", Skin.class);
        this.themes = config.getValues("themes", Theme.class);
        this.entityViewHelper = (EntityViewHelper)config.getValue("entityViewHelper", EntityViewHelper.class);
        this.autoGenerateSetting = new AutoGenerateSetting();
        this.autoGenerateSetting.setShowSystemProperty((Boolean)config.getValue("autoGenerateShowSystemProperty", Boolean.class, (Object)false));
        if (this.autoGenerateSetting.isShowSystemProperty()) {
            if (config.getValue("autoGenerateSystemProperties") != null) {
                HashSet<String> supports = new HashSet<String>(Arrays.asList("oid", "version", "createBy", "createDate", "updateBy", "updateDate", "lockedBy"));
                String systemPropertiesStr = config.getValue("autoGenerateSystemProperties");
                String[] inputArray = systemPropertiesStr.split(",");
                String[] validArray = (String[])Arrays.stream(inputArray).filter(property -> supports.contains(property.trim())).map(String::trim).toArray(String[]::new);
                this.autoGenerateSetting.setSystemProperties(validArray);
            }
            if (config.getValue("autoGenerateSystemPropertyDisplayPosition") != null) {
                String displayPosition = config.getValue("autoGenerateSystemPropertyDisplayPosition");
                this.autoGenerateSetting.setSystemPropertyDisplayPosition(AutoGenerateSetting.DisplayPosition.valueOf(displayPosition));
            }
            this.autoGenerateSetting.setExcludeOidWhenCustomOid((Boolean)config.getValue("autoGenerateExcludeOidWhenCustomOid", Boolean.class, (Object)true));
            this.autoGenerateSetting.setUseUserPropertyEditor((Boolean)config.getValue("autoGenerateUseUserPropertyEditor", Boolean.class, (Object)true));
        }
        this.permitRolesToGem = config.getValues("permitRolesToGem");
        this.permitRolesToNoView = config.getValues("permitRolesToNoView");
    }

    public void destroy() {
    }

    public boolean isLoadWithReference() {
        return this.loadWithReference;
    }

    public boolean isFormatNumberWithComma() {
        return this.formatNumberWithComma;
    }

    public int getCsvDownloadMaxCount() {
        return this.csvDownloadMaxCount;
    }

    public int getUploadableCsvDownloadLoadSize() {
        return this.uploadableCsvDownloadLoadSize;
    }

    public List<String> getCsvDownloadCharacterCode() {
        return this.csvDownloadCharacterCode;
    }

    public boolean isCsvDownloadQuoteAll() {
        return this.csvDownloadQuoteAll;
    }

    public boolean isCsvDownloadReferenceVersion() {
        return this.csvDownloadReferenceVersion;
    }

    public int getCsvUploadCommitCount() {
        return this.csvUploadCommitCount;
    }

    public boolean isCsvUploadAsync() {
        return this.csvUploadAsync;
    }

    public int getCsvUploadStatusPollingInterval() {
        return this.csvUploadStatusPollingInterval;
    }

    public int getSearchResultCacheLimit() {
        return this.searchResultCacheLimit;
    }

    public boolean isConfirmEditSave() {
        return this.confirmEditSave;
    }

    public boolean isConfirmEditCancel() {
        return this.confirmEditCancel;
    }

    @Deprecated
    public boolean isTopViewEditCancelBackToTop() {
        return this.topViewEditCancelBackToTop;
    }

    public boolean isShowSeachCondResetButton() {
        return this.showSeachCondResetButton;
    }

    public int getSearchResultDispRowCount() {
        return this.searchResultDispRowCount;
    }

    public int getSearchInterval() {
        return this.searchInterval;
    }

    public int getCsvDownloadInterval() {
        return this.csvDownloadInterval;
    }

    public boolean isCsvDownloadWithFooter() {
        return this.csvDownloadWithFooter;
    }

    public String getCsvDownloadFooter() {
        return this.csvDownloadFooter;
    }

    public boolean isShowPulldownPleaseSelectLabel() {
        return this.showPulldownPleaseSelectLabel;
    }

    public String getDatePickerDefaultOption() {
        return this.datePickerDefaultOption;
    }

    public List<BinaryDownloadLoggingTargetProperty> getBinaryDownloadLoggingTargetProperty() {
        return this.binaryDownloadLoggingTargetProperty;
    }

    public List<ImageColorSetting> getImageColors() {
        return this.imageColors;
    }

    public List<String> getImageColorNames() {
        if (this.imageColors != null && !this.imageColors.isEmpty()) {
            List<String> imageColorNames = this.imageColors.stream().map(s -> s.getColorName()).collect(Collectors.toList());
            return imageColorNames;
        }
        return Collections.emptyList();
    }

    public List<String> getCssPathList(String skinName) {
        if (this.imageColors != null && !this.imageColors.isEmpty()) {
            List<String> imageColorNames = this.imageColors.stream().flatMap(s -> s.getCssSettings().stream().filter(c -> skinName.equals(c.getSkinName())).map(c -> c.getCssPath())).collect(Collectors.toList());
            return imageColorNames;
        }
        return Collections.emptyList();
    }

    public List<Skin> getSkins() {
        return this.skins;
    }

    public List<Theme> getThemes() {
        return this.themes;
    }

    public EntityViewHelper getEntityViewHelper() {
        return this.entityViewHelper;
    }

    public int getRecycleBinMaxCount() {
        return this.recycleBinMaxCount;
    }

    public int getDeleteAllCommandBatchSize() {
        return this.deleteAllCommandBatchSize;
    }

    public int getBulkUpdateAllCommandBatchSize() {
        return this.bulkUpdateAllCommandBatchSize;
    }

    public boolean isShallowCopyLobData() {
        return this.shallowCopyLobData;
    }

    public AutoGenerateSetting getAutoGenerateSetting() {
        return this.autoGenerateSetting;
    }

    public List<String> getPermitRolesToGem() {
        return this.permitRolesToGem;
    }

    public List<String> getPermitRolesToNoView() {
        return this.permitRolesToNoView;
    }
}

