/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.auth;

import java.util.List;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.GemWebApiParameter;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.action.ActionParameterBinding;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.WebApiParameterBinding;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.generic.EntityViewManager;

public class GemAuth {
    public static boolean isPermitAction(String actionName, ActionParameterBinding param) {
        if (actionName.startsWith("gem/generic/")) {
            String definitionName = (String)param.getValue("defName");
            String viewName = (String)param.getValue("viewName");
            return GemAuth.isPermitEntityView(definitionName, viewName);
        }
        if (actionName.startsWith("gem/")) {
            return GemAuth.isPermitGem();
        }
        return true;
    }

    public static boolean isPermitWebApi(String webApiName, WebApiParameterBinding param) {
        if (webApiName.startsWith("gem/generic/")) {
            String definitionName = null;
            String viewName = null;
            Object paramValue = param.getValue("params");
            if (paramValue == null) {
                definitionName = (String)param.getValue("defName");
                viewName = (String)param.getValue("viewName");
            } else if (paramValue instanceof GemWebApiParameter) {
                GemWebApiParameter gemParam = (GemWebApiParameter)paramValue;
                definitionName = gemParam.getDefName();
                viewName = gemParam.getViewName();
            }
            if (viewName != null && ("null".equals(viewName) || "undefined".equals(viewName))) {
                viewName = null;
            }
            return GemAuth.isPermitEntityView(definitionName, viewName);
        }
        if (webApiName.startsWith("gem/")) {
            return GemAuth.isPermitGem();
        }
        return true;
    }

    public static boolean isPermitEntityView(String definitionName, String viewName) {
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        List<String> permitRoles = evm.getPermitRoles(definitionName, viewName);
        if (permitRoles == null) {
            GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
            permitRoles = service.getPermitRolesToNoView();
        }
        if (permitRoles == null || permitRoles.isEmpty()) {
            return true;
        }
        AuthContext authContext = AuthContext.getCurrentContext();
        return permitRoles.stream().anyMatch(role -> authContext.userInRole(role));
    }

    public static boolean isPermitGem() {
        AuthContext authContext = AuthContext.getCurrentContext();
        GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        if (service.getPermitRolesToGem() == null) {
            return true;
        }
        return service.getPermitRolesToGem().stream().anyMatch(role -> authContext.userInRole(role));
    }
}

