/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;

public class CommandUtil {
    public static final String FORMAT_DATE = "yyyyMMdd";
    public static final String FORMAT_TIMESTAMP = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_TIMESTAMP14 = "yyyyMMddHHmmss";
    public static final String FORMAT_TIMESTAMP8 = "yyyyMMdd";
    public static final String FORMAT_TIME = "HHmmssSSS";
    public static final String FORMAT_TIME6 = "HHmmss";

    public static Integer getInteger(String value) {
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseNumErr", new Object[0]) + "[" + value + "]");
        }
    }

    public static Long getLong(String value) {
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseNumErr", new Object[0]) + "[" + value + "]");
        }
    }

    public static Double getDouble(String value) {
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseNumErr", new Object[0]) + "[" + value + "]");
        }
    }

    public static BigDecimal getDecimal(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseNumErr", new Object[0]) + "[" + value + "]");
        }
    }

    public static Date getDate(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, "yyyyMMdd");
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseDateErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Date(date);
    }

    public static Time getTime(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, FORMAT_TIME);
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseTimeErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Time(date);
    }

    public static Time getTime6(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, FORMAT_TIME6);
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseTimeErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Time(date);
    }

    public static Timestamp getTimestamp(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, FORMAT_TIMESTAMP);
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseDateTimeErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Timestamp(date);
    }

    public static Timestamp getTimestamp14(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, FORMAT_TIMESTAMP14);
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseDateTimeErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Timestamp(date);
    }

    public static Timestamp getTimestamp8(String value) {
        Long date = null;
        try {
            date = CommandUtil.getDateTime(value, "yyyyMMdd");
        }
        catch (ParseException e) {
            throw new ApplicationException(CommandUtil.resourceString("command.CommandUtil.parseDateTimeErr", new Object[0]) + "[" + value + "]");
        }
        if (date == null) {
            return null;
        }
        return new Timestamp(date);
    }

    private static Long getDateTime(String value, String format) throws ParseException {
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        SimpleDateFormat sd = DateUtil.getSimpleDateFormat((String)format, (boolean)true);
        sd.setLenient(false);
        return sd.parse(value).getTime();
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

