/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iplass.gem.command.common.SearchResultData;
import org.iplass.gem.command.common.SearchResultRow;
import org.iplass.gem.command.generic.search.ResponseUtil;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.VirtualPropertyItem;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;

public class CreateSearchResultUtil {
    @Deprecated
    public static List<Map<String, String>> getHtmlData(List<Entity> entityList, EntityDefinition ed, SearchResultSection section, String viewName) throws IOException, ServletException {
        return CreateSearchResultUtil.getResultData(entityList, ed, section, viewName).toResponse();
    }

    public static SearchResultData getResultData(List<Entity> entityList, EntityDefinition ed, SearchResultSection section, String viewName) throws IOException, ServletException {
        SearchResultData result = new SearchResultData();
        if (entityList == null) {
            return result;
        }
        List<Element> elements = section.getElements();
        for (Entity entity : entityList) {
            LinkedHashMap<String, String> rowData = new LinkedHashMap<String, String>();
            SearchResultRow row = new SearchResultRow(entity, rowData);
            rowData.put("orgOid", entity.getOid());
            rowData.put("orgVersion", entity.getVersion().toString());
            if (entity.getUpdateDate() != null) {
                rowData.put("orgTimestamp", String.valueOf(entity.getUpdateDate().getTime()));
            }
            if (entity.getValue("score") != null) {
                rowData.put("score", entity.getValue("score").toString());
            }
            for (Element element : elements) {
                Element property;
                if (element instanceof PropertyColumn) {
                    property = (PropertyColumn)element;
                    CreateSearchResultUtil.outputPropertyColumn(ed, section, entity, rowData, property, viewName);
                    continue;
                }
                if (!(element instanceof VirtualPropertyItem)) continue;
                property = (VirtualPropertyItem)element;
                CreateSearchResultUtil.outputVirtualProperty(ed, section, entity, rowData, (VirtualPropertyItem)property, viewName);
            }
            result.addRow(row);
        }
        return result;
    }

    private static void outputVirtualProperty(EntityDefinition ed, SearchResultSection section, Entity entity, Map<String, String> rowData, VirtualPropertyItem property, String viewName) throws ServletException, IOException {
        PropertyEditor editor;
        String path;
        if (CreateSearchResultUtil.isDispProperty(ed, property) && (path = EntityViewUtil.getJspPath(editor = property.getEditor(), "gem")) != null) {
            String propName = property.getPropertyName();
            PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(property);
            String html = CreateSearchResultUtil.outputHtml(ed, section, entity, rowData, propName, pd, editor, path, viewName);
            rowData.put(propName, html);
        }
    }

    private static void outputPropertyColumn(EntityDefinition ed, SearchResultSection section, Entity entity, Map<String, String> rowData, PropertyColumn property, String viewName) throws ServletException, IOException {
        PropertyEditor editor;
        String path;
        if (CreateSearchResultUtil.isDispProperty(ed, property) && (path = EntityViewUtil.getJspPath(editor = property.getEditor(), "gem")) != null) {
            String propName = property.getPropertyName();
            PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, ed);
            String html = CreateSearchResultUtil.outputHtml(ed, section, entity, rowData, propName, pd, editor, path, viewName);
            WebRequestStack stack = WebRequestStack.getCurrent();
            HttpServletRequest req = stack.getRequest();
            Boolean isNest = (Boolean)req.getAttribute("nest_" + propName);
            if (isNest != null && isNest.booleanValue()) {
                rowData.put(propName + "." + "name", html);
            } else {
                rowData.put(propName, html);
            }
            req.setAttribute("nest_" + propName, null);
        }
    }

    private static String outputHtml(final EntityDefinition ed, SearchResultSection section, final Entity entity, final Map<String, String> rowData, String propName, final PropertyDefinition pd, final PropertyEditor editor, String path, final String viewName) throws ServletException, IOException {
        final Object propValue = entity.getValue(propName);
        ResponseUtil.Func beforeFunc = new ResponseUtil.Func(){

            @Override
            public void execute(HttpServletRequest req, HttpServletResponse res) {
                req.setAttribute("outputType", (Object)OutputType.SEARCHRESULT);
                req.setAttribute("editor", (Object)editor);
                req.setAttribute("value", (Object)entity);
                req.setAttribute("propValue", propValue);
                req.setAttribute("entityDefinition", (Object)ed);
                req.setAttribute("propertyDefinition", (Object)pd);
                req.setAttribute("entityValueMap", (Object)rowData);
                req.setAttribute("viewName", (Object)viewName);
                req.setAttribute("rootDefName", (Object)ed.getName());
                req.setAttribute("viewType", (Object)"searchResult");
            }
        };
        ResponseUtil.Func afterFunc = new ResponseUtil.Func(){

            @Override
            public void execute(HttpServletRequest req, HttpServletResponse res) {
                req.removeAttribute("outputType");
                req.removeAttribute("editor");
                req.removeAttribute("value");
                req.removeAttribute("propValue");
                req.removeAttribute("entityDefinition");
                req.removeAttribute("entityValueMap");
                req.removeAttribute("viewName");
                req.removeAttribute("rootDefName");
                req.removeAttribute("viewType");
            }
        };
        editor.setPropertyName(propName);
        String html = ResponseUtil.getIncludeJspContents(path, beforeFunc, afterFunc).replace("\r\n", "").replace("\n", "").replace("\r", "");
        if (StringUtil.isNotEmpty((String)editor.getCustomStyle())) {
            String customStyle = EntityViewUtil.getCustomStyle(entity.getDefinitionName(), section.getScriptKey(), editor.getOutputCustomStyleScriptKey(), entity, propValue);
            html = "<span style=\"" + customStyle + "\">" + html + "</span>";
        }
        return html;
    }

    private static boolean isDispProperty(EntityDefinition ed, Element element) {
        if (!EntityViewUtil.isDisplayElement(ed.getName(), element.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) {
            return false;
        }
        if (element instanceof PropertyColumn && ((PropertyColumn)element).getEditor() != null) {
            return true;
        }
        return element instanceof VirtualPropertyItem && ((VirtualPropertyItem)element).getEditor() != null;
    }
}

