/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.util.ResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.TemplateUtil;

public class GemResourceBundleUtil {
    public static final String RESOURCE_NAME = "mtp-gem-messages";

    private GemResourceBundleUtil() {
    }

    public static List<LocalizedStringDefinition> resourceList(String key, Object ... arguments) {
        if (TemplateUtil.getEnableLanguages() != null) {
            ArrayList<LocalizedStringDefinition> list = new ArrayList<LocalizedStringDefinition>();
            for (String lang : TemplateUtil.getEnableLanguages().keySet()) {
                String msg = GemResourceBundleUtil.resourceString(lang, key, arguments);
                if (!StringUtil.isNotEmpty((String)msg)) continue;
                LocalizedStringDefinition trueDef = new LocalizedStringDefinition();
                trueDef.setLocaleName(lang);
                trueDef.setStringValue(msg);
                list.add(trueDef);
            }
            return list;
        }
        return null;
    }

    public static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(null, key, arguments);
    }

    private static String resourceString(String lang, String key, Object ... arguments) {
        Locale langLocale = null;
        langLocale = StringUtil.isNotEmpty((String)lang) ? Locale.forLanguageTag(lang) : ExecuteContext.getCurrentContext().getLangLocale();
        return ResourceBundleUtil.resourceString((String)RESOURCE_NAME, (Locale)langLocale, (String)key, (Object[])arguments);
    }
}

